
/**
    @brief		RcNX
    @author		t`
*/

//=============================================================================
// INCLUDE
//=============================================================================
#include "LunaBase.h"

#include "Luna3D.h"
#include "LunaMain.h"
#include "LunaCamera.h"
#include "LunaLight.h"
#include "LunaField.h"
#include "LunaDebug.h"
#include "LunaLine.h"
#include "LunaLine3D.h"
#include "LunaPoint.h"
#include "LunaPoint3D.h"
#include "LunaPrimitive.h"
#include "LunaPrimitive3D.h"
#include "LunaSprite.h"
#include "LunaSprite3D.h"
#include "LunaSurface.h"
#include "LunaTexture.h"
#include "LunaVMR9.h"
#include "LunaModel.h"
#include "LunaModelEx.h"
#include "LunaShaderEffect.h"
#include "LunaSimple.h"


using namespace LibLuna;

//=============================================================================
// CONSTANT
//=============================================================================

//---------------------------------------------------------------
// obNobt@tH[}bg
//---------------------------------------------------------------
static const D3DFORMAT BackBufferFormats[] = {
	D3DFMT_X8R8G8B8,
	D3DFMT_X1R5G5B5,
	D3DFMT_R5G6B5,
	D3DFMT_UNKNOWN,
};


//---------------------------------------------------------------
// eNX`tH[}bg
//---------------------------------------------------------------
static D3DFORMAT TextureFormats[] = {
	D3DFMT_R5G6B5,			D3DFMT_X1R5G5B5,		D3DFMT_A1R5G5B5,
	D3DFMT_A4R4G4B4,		D3DFMT_R8G8B8,			D3DFMT_A8R8G8B8,
	D3DFMT_X8R8G8B8,		D3DFMT_R3G3B2,			D3DFMT_A8,
	D3DFMT_A8R3G3B2,		D3DFMT_X4R4G4B4,		D3DFMT_A2B10G10R10,
	D3DFMT_A2R10G10B10,		D3DFMT_A16B16G16R16,	D3DFMT_A8P8,
	D3DFMT_P8,				D3DFMT_L8,				D3DFMT_L16,
	D3DFMT_A8L8,			D3DFMT_A4L4,			D3DFMT_V8U8,
	D3DFMT_Q8W8V8U8,		D3DFMT_V16U16,			D3DFMT_Q16W16V16U16,
	D3DFMT_CxV8U8,			D3DFMT_L6V5U5,			D3DFMT_X8L8V8U8,
	D3DFMT_A2W10V10U10,		D3DFMT_G8R8_G8B8,		D3DFMT_R8G8_B8G8,
	D3DFMT_DXT5,			D3DFMT_DXT4,			D3DFMT_DXT3,
	D3DFMT_DXT2,			D3DFMT_DXT1,			D3DFMT_UYVY,
	D3DFMT_YUY2,			D3DFMT_D16_LOCKABLE,	D3DFMT_D32,
	D3DFMT_D15S1,			D3DFMT_D24S8,			D3DFMT_D24X8,
	D3DFMT_D24X4S4,			D3DFMT_D32F_LOCKABLE,	D3DFMT_D24FS8,
	D3DFMT_D16,				D3DFMT_VERTEXDATA,		D3DFMT_INDEX16,
	D3DFMT_INDEX32,			D3DFMT_R16F,			D3DFMT_G16R16F,
	D3DFMT_A16B16G16R16F,	D3DFMT_R32F,			D3DFMT_G32R32F,
	D3DFMT_A32B32G32R32F,	D3DFMT_G16R16,			D3DFMT_UNKNOWN,
};


//---------------------------------------------------------------
// [xobt@tH[}bg
//---------------------------------------------------------------
static D3DFORMAT DepthFormats[] = {
	D3DFMT_D16,				D3DFMT_D32,				D3DFMT_D24S8,
	D3DFMT_D24X8,			D3DFMT_D24X4S4,			D3DFMT_D24FS8,
	D3DFMT_D15S1,			D3DFMT_UNKNOWN,
};


//---------------------------------------------------------------
// foCX^Cv
//---------------------------------------------------------------
static D3DDEVTYPE DeviceType[3] = {
	D3DDEVTYPE_HAL,													// 0
	D3DDEVTYPE_HAL,													// 1
	D3DDEVTYPE_REF,													// 2
};


//---------------------------------------------------------------
// _
//---------------------------------------------------------------
static Uint32 CreateFlag[3] = {
	D3DCREATE_MIXED_VERTEXPROCESSING,								// 0
	D3DCREATE_SOFTWARE_VERTEXPROCESSING,							// 1
	D3DCREATE_SOFTWARE_VERTEXPROCESSING,							// 2
};

//---------------------------------------------------------------
// _[Xe[gꗗ
//---------------------------------------------------------------
static D3DRENDERSTATETYPE RenderStateTbl[] =
{
    D3DRS_ZENABLE,
    D3DRS_FILLMODE,
    D3DRS_SHADEMODE,
    D3DRS_ZWRITEENABLE,
    D3DRS_ALPHATESTENABLE,
    D3DRS_LASTPIXEL,
    D3DRS_SRCBLEND,
    D3DRS_DESTBLEND,
    D3DRS_CULLMODE,
    D3DRS_ZFUNC,
    D3DRS_ALPHAREF,
    D3DRS_ALPHAFUNC,
    D3DRS_DITHERENABLE,
    D3DRS_ALPHABLENDENABLE,
    D3DRS_FOGENABLE,
    D3DRS_SPECULARENABLE,
    D3DRS_FOGCOLOR,
    D3DRS_FOGTABLEMODE,
    D3DRS_FOGSTART,
    D3DRS_FOGEND,
    D3DRS_FOGDENSITY,
    D3DRS_RANGEFOGENABLE,
    D3DRS_STENCILENABLE,
    D3DRS_STENCILFAIL,
    D3DRS_STENCILZFAIL,
    D3DRS_STENCILPASS,
    D3DRS_STENCILFUNC,
    D3DRS_STENCILREF,
    D3DRS_STENCILMASK,
    D3DRS_STENCILWRITEMASK,
    D3DRS_TEXTUREFACTOR,
    D3DRS_WRAP0,
    D3DRS_WRAP1,
    D3DRS_WRAP2,
    D3DRS_WRAP3,
    D3DRS_WRAP4,
    D3DRS_WRAP5,
    D3DRS_WRAP6,
    D3DRS_WRAP7,
    D3DRS_CLIPPING,
    D3DRS_LIGHTING,
    D3DRS_AMBIENT,
    D3DRS_FOGVERTEXMODE,
    D3DRS_COLORVERTEX,
    D3DRS_LOCALVIEWER,
    D3DRS_NORMALIZENORMALS,
    D3DRS_DIFFUSEMATERIALSOURCE,
    D3DRS_SPECULARMATERIALSOURCE,
    D3DRS_AMBIENTMATERIALSOURCE,
    D3DRS_EMISSIVEMATERIALSOURCE,
    D3DRS_VERTEXBLEND,
    D3DRS_CLIPPLANEENABLE,
    D3DRS_POINTSIZE,
    D3DRS_POINTSIZE_MIN,
    D3DRS_POINTSPRITEENABLE,
    D3DRS_POINTSCALEENABLE,
    D3DRS_POINTSCALE_A,
    D3DRS_POINTSCALE_B,
    D3DRS_POINTSCALE_C,
    D3DRS_MULTISAMPLEANTIALIAS,
    D3DRS_MULTISAMPLEMASK,
    D3DRS_PATCHEDGESTYLE,
    D3DRS_DEBUGMONITORTOKEN,
    D3DRS_POINTSIZE_MAX,
    D3DRS_INDEXEDVERTEXBLENDENABLE,
    D3DRS_COLORWRITEENABLE,
    D3DRS_TWEENFACTOR,
    D3DRS_BLENDOP,
    D3DRS_POSITIONDEGREE,
    D3DRS_NORMALDEGREE,
    D3DRS_SCISSORTESTENABLE,
    D3DRS_SLOPESCALEDEPTHBIAS,
    D3DRS_ANTIALIASEDLINEENABLE,
    D3DRS_MINTESSELLATIONLEVEL,
    D3DRS_MAXTESSELLATIONLEVEL,
    D3DRS_ADAPTIVETESS_X,
    D3DRS_ADAPTIVETESS_Y,
    D3DRS_ADAPTIVETESS_Z,
    D3DRS_ADAPTIVETESS_W,
    D3DRS_ENABLEADAPTIVETESSELLATION,
    D3DRS_TWOSIDEDSTENCILMODE,
    D3DRS_CCW_STENCILFAIL,
    D3DRS_CCW_STENCILZFAIL,
    D3DRS_CCW_STENCILPASS,
    D3DRS_CCW_STENCILFUNC,
    D3DRS_COLORWRITEENABLE1,
    D3DRS_COLORWRITEENABLE2,
    D3DRS_COLORWRITEENABLE3,
    D3DRS_BLENDFACTOR,
    D3DRS_SRGBWRITEENABLE,
    D3DRS_DEPTHBIAS,
    D3DRS_WRAP8,
    D3DRS_WRAP9,
    D3DRS_WRAP10,
    D3DRS_WRAP11,
    D3DRS_WRAP12,
    D3DRS_WRAP13,
    D3DRS_WRAP14,
    D3DRS_WRAP15,
    D3DRS_SEPARATEALPHABLENDENABLE,
    D3DRS_SRCBLENDALPHA,
    D3DRS_DESTBLENDALPHA,
    D3DRS_BLENDOPALPHA,
};

static Uint32 RenderStateTblCount = sizeof(RenderStateTbl) / sizeof(D3DRENDERSTATETYPE);


//---------------------------------------------------------------
// eNX`Xe[gꗗ
//---------------------------------------------------------------
static D3DTEXTURESTAGESTATETYPE TextureStateTbl[] =
{
    D3DTSS_COLOROP,
    D3DTSS_COLORARG1,
    D3DTSS_COLORARG2,
    D3DTSS_ALPHAOP,
    D3DTSS_ALPHAARG1,
    D3DTSS_ALPHAARG2,
    D3DTSS_BUMPENVMAT00,
    D3DTSS_BUMPENVMAT01,
    D3DTSS_BUMPENVMAT10,
    D3DTSS_BUMPENVMAT11,
    D3DTSS_TEXCOORDINDEX,
    D3DTSS_BUMPENVLSCALE,
    D3DTSS_BUMPENVLOFFSET,
    D3DTSS_TEXTURETRANSFORMFLAGS,
    D3DTSS_COLORARG0,
    D3DTSS_ALPHAARG0,
    D3DTSS_RESULTARG,
    D3DTSS_CONSTANT,
};

static Uint32 TextureStateTblCount = sizeof(TextureStateTbl) / sizeof(D3DTEXTURESTAGESTATETYPE);


//---------------------------------------------------------------
// Tv[Xe[gꗗ
//---------------------------------------------------------------
static D3DSAMPLERSTATETYPE SamplerStateTbl[] =
{
    D3DSAMP_ADDRESSU,
    D3DSAMP_ADDRESSV,
    D3DSAMP_ADDRESSW,
    D3DSAMP_BORDERCOLOR,
    D3DSAMP_MAGFILTER,
    D3DSAMP_MINFILTER,
    D3DSAMP_MIPFILTER,
    D3DSAMP_MIPMAPLODBIAS,
    D3DSAMP_MAXMIPLEVEL,
    D3DSAMP_MAXANISOTROPY,
    D3DSAMP_SRGBTEXTURE,
    D3DSAMP_ELEMENTINDEX,
    D3DSAMP_DMAPOFFSET,
};

static Uint32 SamplerStateTblCount = sizeof(SamplerStateTbl) / sizeof(D3DSAMPLERSTATETYPE);


//=============================================================================
// VARIABLE
//=============================================================================
Sint32					Luna3D::m_SceneCount;
HINSTANCE				Luna3D::m_hDllD3D9;
IDirect3D9				*Luna3D::m_pDirect3D;
IDirect3DDevice9		*Luna3D::m_pDevice;
IDirect3DSurface9		*Luna3D::m_pRenderTarget;
IDirect3DQuery9			*Luna3D::m_pQuery[2];
D3DVIEWPORT9			Luna3D::m_Viewport;
char					Luna3D::m_AdapterName[128];
char					Luna3D::m_AdapterDriver[128];
char					Luna3D::m_AdapterVersion[128];
D3DMULTISAMPLE_TYPE		Luna3D::m_MultiSampleType;
Uint32					Luna3D::m_MultiSampleQuality;
DEVICEINFORMATION		Luna3D::m_DeviceInfo;
D3DDISPLAYMODE			Luna3D::m_WindowMode;
D3DDISPLAYMODE			Luna3D::m_FullScreenMode[2];
ADAPTERDATA				Luna3D::m_AdapterData;
D3DPRESENT_PARAMETERS	Luna3D::m_PresentParams[2];
LCAMERA					Luna3D::m_lCamera;
LTEXTURE				Luna3D::m_lTexTarget;
LSURFACE				Luna3D::m_lSurfTarget;
LSURFACE				Luna3D::m_lSurfDepthStencil;
LTEXTURE				Luna3D::m_lTexActive[TEXTURE_STAGE_MAX];
Uint32					Luna3D::m_RenderState[RENDER_STATE_TBL_MAX];
Uint32					Luna3D::m_SamplerState[TEXTURE_STAGE_MAX][SAMPLER_STATE_TBL_MAX];
Uint32					Luna3D::m_TextureState[TEXTURE_STAGE_MAX][TEXTURE_STATE_TBL_MAX];
Uint32					Luna3D::m_MaxVertexShaderVersion;
HFONT					Luna3D::m_hFont;
HFONT					Luna3D::m_hOldFont;
HDC						Luna3D::m_hDC;
Float					Luna3D::m_FogNear;
Float					Luna3D::m_FogFar;
D3DCOLOR				Luna3D::m_FogColor;
Bool					Luna3D::m_IsWaitBlank;
Bool					Luna3D::m_IsFullColor;
Bool					Luna3D::m_IsEmulationMode;
Bool					Luna3D::m_IsLocked;
Bool					Luna3D::m_IsCheckingFillRate;
Bool					Luna3D::m_IsNVPerfHUD;
void					(*Luna3D::m_pCallbackReset)( void );
void					(*Luna3D::m_pCallbackRestore)( void );
MATERIALSTATE			Luna3D::m_DefaultState;

eSurfaceFormat Luna3D::m_SurfaceFormatTbl[2][16] = {
	{ FORMAT_TEXTURE32,	FORMAT_TEXTURE16,	FORMAT_DXT5,		FORMAT_DXT3 },
	{ FORMAT_DXT5,		FORMAT_DXT3,		FORMAT_TEXTURE32,	FORMAT_TEXTURE16 },
};
Uint32 Luna3D::m_SurfaceFormatCount[2] = { 4, 4 };


//=============================================================================
/**
	RcNX̏܂B

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::Initialize( void )
{
	Luna::LogoutMainCategory( "Luna3DNX̏" );
	Luna::LogoutNextLine();

	//----------------------------------------------------------
	// ftHgl
	//----------------------------------------------------------
	m_MaxVertexShaderVersion = D3DVS_VERSION(2,0);

	//----------------------------------------------------------
	// A_v^[̏
	//----------------------------------------------------------
	if ( !Luna3D::InitAdapter() )
	{
		Luna::MsgBox( MB_ICONERROR, "Luna3D", "A_v^[̏Ɏs" );
		return false;
	}

	return true;
}

//=============================================================================
/**
	RcNX̉܂B

*/
//=============================================================================
void Luna3D::Finalize( void )
{
	Luna::LogoutMainCategory( "Luna3DNX̉" );
	Luna::LogoutNextLine();

	for ( Sint32 i = 0; i < 2; i++ )
	{
		if ( m_pQuery[i] != NULL )
		{
			m_pQuery[i]->Release();
			m_pQuery[i] = NULL;
			Luna::Logout( "IDirect3DQuery9C^[tF[X" );
			Luna::LogoutNextLine();
		}
	}

	SAFE_RELEASE( m_pRenderTarget );

	if ( m_pDevice != NULL )
	{
		m_pDevice->Release();
		m_pDevice = NULL;
		Luna::Logout( "Direct3DfoCX" );
		Luna::LogoutNextLine();
	}

	if ( m_pDirect3D != NULL )
	{
		m_pDirect3D->Release();
		m_pDirect3D = NULL;
		Luna::Logout( "Direct3DIuWFNg" );
		Luna::LogoutNextLine();
	}

	if ( m_hDllD3D9 != NULL )
	{
		::FreeLibrary( m_hDllD3D9 );
		m_hDllD3D9 = NULL;
		Luna::Logout( "DLL" );
		Luna::LogoutNextLine();
	}

	Luna::LogoutNextLine();
}

//=============================================================================
/**
	A_v^[̏܂B

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::InitAdapter( void )
{
	//---------------------------------------------------------------
	// Direct3DIuWFNg̐
	//---------------------------------------------------------------
	if ( !Luna3D::CreateDirect3DObject() )
	{
		return false;
	}

	//---------------------------------------------------------------
	// A_v^[̃`FbN
	//---------------------------------------------------------------
	if ( !Luna3D::CheckAdapterInformation() )
	{
		return false;
	}

	//---------------------------------------------------------------
	// foCX̃`FbN
	//---------------------------------------------------------------
	if ( !Luna3D::CheckDeviceInformation() )
	{
		return false;
	}

	return true;
}

//=============================================================================
/**
	Direct3DIuWFNg̐܂B

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::CreateDirect3DObject( void )
{
	PDIRECT3DCREATE9 pProcDirect3DCreate9 = NULL;

	//---------------------------------------------------------------
	// Load DLL
	//---------------------------------------------------------------
	m_hDllD3D9 = ::LoadLibrary( "d3d9.dll" );
	if ( m_hDllD3D9 == NULL )
	{
		Luna::LogoutError( "@@@G[ : DLL̓ǂݍ݂Ɏs" );
		Luna::LogoutNextLine();
		Luna::LogoutError( "@@@DirectX9cCXg[Ă邩mFĉ" );
		Luna::LogoutNextLine();
		Luna::MsgBox( MB_ICONERROR, "Luna3D", "DLL̓ǂݍ݂Ɏs\nDirectX9cCXg[Ă邩\nmFĉ" );
		return false;
	}

	//---------------------------------------------------------------
	// Load Direct3DCreate from DLL
	//---------------------------------------------------------------
	pProcDirect3DCreate9 = (PDIRECT3DCREATE9)::GetProcAddress( m_hDllD3D9, "Direct3DCreate9" );
	if ( pProcDirect3DCreate9 == NULL )
	{
		Luna::LogoutError( "@@@G[ : DLL̊֐ĂяoɎs" );
		Luna::LogoutNextLine();
		Luna::LogoutError( "@@@DirectX9cCXg[Ă邩mFĉ" );
		Luna::LogoutNextLine();
		Luna::MsgBox( MB_ICONERROR, "Luna3D", "DLL̊֐ĂяoɎs\nDirectX9cCXg[Ă邩\nmFĉ" );
		return false;
	}

	//---------------------------------------------------------------
	// Create Direct3D Object
	//---------------------------------------------------------------
	m_pDirect3D = pProcDirect3DCreate9( D3D_SDK_VERSION );
	if ( m_pDirect3D == NULL )
	{
		Luna::LogoutError( "@@@G[ : Direct3DIuWFNg̐Ɏs" );
		Luna::LogoutNextLine();
		Luna::LogoutError( "@@@DirectX9cCXg[Ă邩mFĉ" );
		Luna::LogoutNextLine();
		Luna::MsgBox( MB_ICONERROR, "Luna3D", "Direct3DIuWFNg̐Ɏs\nDirectX9cCXg[Ă邩\nmFĉ" );
		return false;
	}

	return true;
}

//=============================================================================
/**
	A_v^[̎擾܂B

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::CheckAdapterInformation( void )
{
	D3DADAPTER_IDENTIFIER9 Identifier;
	HRESULT hr;

	//---------------------------------------------------------------
	// A_v^[
	//---------------------------------------------------------------
	Luna::LogoutKeyword( "A_v^[" );
	Luna::LogoutNextLine();

	hr = m_pDirect3D->GetAdapterIdentifier( D3DADAPTER_DEFAULT, 0, &Identifier );
	if SUCCEEDED( hr )
	{
		strcpy( m_AdapterName, Identifier.Description );
		strcpy( m_AdapterDriver, Identifier.Driver );
		sprintf(
			m_AdapterVersion,
			"%u.%u.%u.%u",
			HIWORD(Identifier.DriverVersion.HighPart),
			LOWORD(Identifier.DriverVersion.HighPart),
			HIWORD(Identifier.DriverVersion.LowPart),
			LOWORD(Identifier.DriverVersion.LowPart) );

		Luna::Logout( "@@@Name [ %s ]", Identifier.Description );
		Luna::LogoutNextLine();
		Luna::Logout( "@@@Driver [ %s ]", Identifier.Driver );
		Luna::LogoutNextLine();
		Luna::Logout( "@@@Product [ %u ]", HIWORD(Identifier.DriverVersion.HighPart) );
		Luna::LogoutNextLine();
		Luna::Logout( "@@@Version [ %u.%u.%u ]",
			LOWORD(Identifier.DriverVersion.HighPart),
			HIWORD(Identifier.DriverVersion.LowPart),
			LOWORD(Identifier.DriverVersion.LowPart) );
		Luna::LogoutNextLine();

		Luna::Logout( "@Windows Hardware Quality Lab (WHQL) F؃x" );
		Luna::LogoutNextLine();

		if ( Identifier.WHQLLevel == 0 )
		{
			Luna::Logout( "@@@F؂ĂȂB" );
			Luna::LogoutNextLine();
		}
		ef ( Identifier.WHQLLevel == 1 )
		{
			Luna::Logout( "@@@WHQL ̔F؂͎󂯂Ă邪Apłt͂ȂB" );
			Luna::LogoutNextLine();
		}
		else
		{
			Luna::Logout( "@@@%u.%u.%u",
				((Identifier.WHQLLevel>>16)&0xFF), ((Identifier.WHQLLevel>>8)&0x0F), ((Identifier.WHQLLevel>>0)&0x0F) );
			Luna::LogoutNextLine();
		}
	}

	Luna::LogoutNextLine();

	//---------------------------------------------------------------
	// ݂̉ʃ[h擾
	//---------------------------------------------------------------
	Luna::LogoutKeyword( "݂̉ʏ" );
	Luna::LogoutNextLine();

	hr = m_pDirect3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &m_WindowMode );
	if SUCCEEDED( hr )
	{
		Luna::Logout( "@@@Width [ %u ]", m_WindowMode.Width );
		Luna::LogoutNextLine();

		Luna::Logout( "@@@Height [ %u ]", m_WindowMode.Height );
		Luna::LogoutNextLine();

		Luna::Logout( "@@@RefreshRate [ %u ]", m_WindowMode.RefreshRate );
		Luna::LogoutNextLine();

		Luna::Logout( "@@@Format [ %s ]", Luna3D::GetPixelFormat(m_WindowMode.Format) );
		Luna::LogoutNextLine();
	}

	Luna::LogoutNextLine();

	//---------------------------------------------------------------
	// tXN[Ɏgp\ȉʃ[h񋓂
	//---------------------------------------------------------------
	Luna::LogoutKeyword( "gp\ȉʃ[h" );
	Luna::LogoutNextLine();

	for ( Sint32 i = 0; BackBufferFormats[i] != D3DFMT_UNKNOWN; i++ )
	{
		// fBXvC[h̎擾
		D3DDISPLAYMODE DisplayMode;
		Uint32 ModeCount = m_pDirect3D->GetAdapterModeCount( D3DADAPTER_DEFAULT, BackBufferFormats[i] );

		if ( ModeCount > 0 )
		{
			Luna::LogoutStrong( "@BackBuffer Format [ %s ]", GetPixelFormat(BackBufferFormats[i]) );
			Luna::LogoutNextLine();

			// [h
			for ( Uint32 j = 0; j < ModeCount; j++ )
			{
				hr = m_pDirect3D->EnumAdapterModes( D3DADAPTER_DEFAULT, BackBufferFormats[i], j, &DisplayMode );
				if SUCCEEDED( hr )
				{
					Bool IsNew = true;

					// ʃTCY̌
					for ( Sint32 k = 0; k < m_AdapterData.ModeCount; k++ )
					{
						if ( m_AdapterData.Mode[k].Width == DisplayMode.Width )
						{
							if ( m_AdapterData.Mode[k].Height == DisplayMode.Height )
							{
								if ( m_AdapterData.Mode[k].Format == DisplayMode.Format )
								{
									IsNew = false;
								}
							}
						}
					}

					// ʃTCYȂꍇ͐VĂ
					if ( IsNew )
					{
						m_AdapterData.Mode[m_AdapterData.ModeCount++] = DisplayMode;
						Luna::Logout( "@@@[ %u x %u ] [ %uHz ]", DisplayMode.Width, DisplayMode.Height, DisplayMode.RefreshRate );
						Luna::LogoutNextLine();
					}

				}
			}

			Luna::LogoutNextLine();
		}
	}

	Luna::LogoutNextLine();

	//---------------------------------------------------------------
	// tXN[[hp̃fBXvC[hݒ
	//---------------------------------------------------------------
	Luna::LogoutKeyword( "tXN[pfBXvC[ȟ" );
	Luna::LogoutNextLine();

	Sint32 Width, Height;
	Luna::GetScreenData( &Width, &Height, NULL );

	// NA
	m_FullScreenMode[0].Format = D3DFMT_UNKNOWN;
	m_FullScreenMode[1].Format = D3DFMT_UNKNOWN;

	// 
	for ( Sint32 j = 0; j < m_AdapterData.ModeCount; j++ )
	{
		if ( m_AdapterData.Mode[j].Width == (Uint32)Width )
		{
			if ( m_AdapterData.Mode[j].Height == (Uint32)Height )
			{
				switch ( m_AdapterData.Mode[j].Format )
				{
				// 16Bit
				case D3DFMT_X1R5G5B5:
				case D3DFMT_R5G6B5:
					m_FullScreenMode[0] = m_AdapterData.Mode[j];
					break;
				// 32Bit
				case D3DFMT_X8R8G8B8:
					m_FullScreenMode[1] = m_AdapterData.Mode[j];
					break;
				}
			}
		}
	}

	// O
	Luna::Logout( "@@@16BitColor [ %s ]", Luna3D::GetPixelFormat(m_FullScreenMode[0].Format) );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@32BitColor [ %s ]", Luna3D::GetPixelFormat(m_FullScreenMode[1].Format) );
	Luna::LogoutNextLine();

	Luna::LogoutNextLine();

	//---------------------------------------------------------------
	// eNX`tH[}bggp\Ȃ̂
	//---------------------------------------------------------------
	Luna::LogoutKeyword( "gp\ȃeNX`tH[}bg" );
	Luna::LogoutNextLine();

	D3DFORMAT BaseFormat = m_FullScreenMode[1].Format == D3DFMT_UNKNOWN ? m_WindowMode.Format : m_FullScreenMode[1].Format;

	for ( Sint32 i = 0; TextureFormats[i] != D3DFMT_UNKNOWN; i++ )
	{
		hr = m_pDirect3D->CheckDeviceFormat(
						D3DADAPTER_DEFAULT,
						D3DDEVTYPE_HAL,
						BaseFormat,
						D3DUSAGE_AUTOGENMIPMAP,
						D3DRTYPE_TEXTURE,
						TextureFormats[i] );
		if ( SUCCEEDED(hr) && (hr != D3DOK_NOAUTOGEN) )
		{
			m_AdapterData.TextureFormats[ m_AdapterData.TextureCount ] = TextureFormats[i];
			m_AdapterData.TextureMipmap[ m_AdapterData.TextureCount ] = true;
			m_AdapterData.TextureCount++;

			Luna::Logout( "@@@ [ %s ]", Luna3D::GetPixelFormat(TextureFormats[i]) );
			Luna::LogoutNextLine();
		}
		else
		{
			hr = m_pDirect3D->CheckDeviceFormat(
							D3DADAPTER_DEFAULT,
							D3DDEVTYPE_HAL,
							BaseFormat,
							0,
							D3DRTYPE_TEXTURE,
							TextureFormats[i] );
			if SUCCEEDED( hr )
			{
				m_AdapterData.TextureFormats[ m_AdapterData.TextureCount ] = TextureFormats[i];
				m_AdapterData.TextureMipmap[ m_AdapterData.TextureCount ] = false;
				m_AdapterData.TextureCount++;

				Luna::Logout( "@@@~ [ %s ]", Luna3D::GetPixelFormat(TextureFormats[i]) );
				Luna::LogoutNextLine();
			}
		}
	}

	Luna::LogoutNextLine();

	//---------------------------------------------------------------
	// _O^[QbgeNX`tH[}bggp\Ȃ̂
	//---------------------------------------------------------------
	Luna::LogoutKeyword( "gp\ȃ_O^[QbgeNX`tH[}bg" );
	Luna::LogoutNextLine();

	for ( Sint32 i = 0; TextureFormats[i] != D3DFMT_UNKNOWN; i++ )
	{
		hr = m_pDirect3D->CheckDeviceFormat(
						D3DADAPTER_DEFAULT,
						D3DDEVTYPE_HAL,
						BaseFormat,
						D3DUSAGE_RENDERTARGET,
						D3DRTYPE_TEXTURE,
						TextureFormats[i] );
		if SUCCEEDED( hr )
		{
			m_AdapterData.TargetFormats[ m_AdapterData.TargetCount++ ] = TextureFormats[i];

			Luna::Logout( "@@@[ %s ]", Luna3D::GetPixelFormat(TextureFormats[i]) );
			Luna::LogoutNextLine();
		}
	}

	Luna::LogoutNextLine();

	//---------------------------------------------------------------
	// [xobt@tH[}bggp\Ȃ̂
	//---------------------------------------------------------------
	Luna::LogoutKeyword( "gp\Ȑ[xobt@tH[}bg" );
	Luna::LogoutNextLine();

	for ( Sint32 i = 0; DepthFormats[i] != D3DFMT_UNKNOWN; i++ )
	{
		hr = m_pDirect3D->CheckDeviceFormat(
								D3DADAPTER_DEFAULT,
								D3DDEVTYPE_HAL,
								BaseFormat,
								D3DUSAGE_DEPTHSTENCIL,
								D3DRTYPE_SURFACE,
								DepthFormats[i] );
		if SUCCEEDED( hr )
		{
			m_AdapterData.DepthFormats[ m_AdapterData.DepthCount++ ] = DepthFormats[i];

			Luna::Logout( "@@@[ %s ]", Luna3D::GetPixelFormat(DepthFormats[i]) );
			Luna::LogoutNextLine();
		}
	}

	Luna::LogoutNextLine();

	return true;
}

//=============================================================================
/**
	RcfoCX̐\`FbN܂B

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::CheckDeviceInformation( void )
{
	Luna::LogoutKeyword( "foCX\͂̎擾" );
	Luna::LogoutNextLine();

	D3DCAPS9 Caps;

	//-----------------------------------------------------------
	// n[hEFAfoCX̐\擾
	//-----------------------------------------------------------
	m_pDirect3D->GetDeviceCaps( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, &Caps );
	GetDeviceCaps( &Caps, &m_DeviceInfo );

	//-----------------------------------------------------------
	// n[hEFAfoCX̐\
	//-----------------------------------------------------------
	Luna::LogoutStrong( "@foCX\" );
	Luna::LogoutNextLine();

	Luna::Logout( "@@@[ %s ] sAfoCX", m_DeviceInfo.IsPureDevice ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] n[hEFAsk", m_DeviceInfo.IsHardwareTnL ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] n[hEFAX^CY", m_DeviceInfo.IsSoftwareTnL ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] ٕtB^O", m_DeviceInfo.IsAnisotropy ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fBUO", m_DeviceInfo.IsDither ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] [xoCAX", m_DeviceInfo.IsDepthBias ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] vobt@", m_DeviceInfo.IsWBuffer ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] ~bv}bv", m_DeviceInfo.IsAutoMipMap ? "" : "~" );
	Luna::LogoutNextLine();

	Luna::LogoutStrong( "@[xeXg\" );
	Luna::LogoutNextLine();

	Luna::Logout( "@@@[ %s ] [xeXg ALWAYS", m_DeviceInfo.IsZCmpAlways ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] [xeXg EQUAL", m_DeviceInfo.IsZCmpEqual ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] [xeXg GREATER", m_DeviceInfo.IsZCmpGreater ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] [xeXg GREATER EQUA", m_DeviceInfo.IsZCmpGreaterEqual ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] [xeXg LESS", m_DeviceInfo.IsZCmpLess ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] [xeXg LESS EQUAL", m_DeviceInfo.IsZCmpLessEqual ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] [xeXg NEVER", m_DeviceInfo.IsZCmpNever ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] [xeXg NOT EQUAL", m_DeviceInfo.IsZCmpNotEqual ? "" : "~" );
	Luna::LogoutNextLine();

	Luna::LogoutStrong( "@\[Xuh\" );
	Luna::LogoutNextLine();

	Luna::Logout( "@@@[ %s ] \[Xuh BLEND FACTOR", m_DeviceInfo.IsSrcBlendFactor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh BOTH INVSRC", m_DeviceInfo.IsSrcBothInvSrc ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh BOTH SRC", m_DeviceInfo.IsSrcBothSrc ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh DEST ALPHA", m_DeviceInfo.IsSrcDestAlpha ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh DEST COLOR", m_DeviceInfo.IsSrcDestColor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh INV DEST ALPHA", m_DeviceInfo.IsSrcInvDestAlpha ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh INV DEST COLOR", m_DeviceInfo.IsSrcInvDestColor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh INV SRC ALPHA", m_DeviceInfo.IsSrcInvSrcAlpha ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh INV SRC COLOR", m_DeviceInfo.IsSrcInvSrcColor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh ONE", m_DeviceInfo.IsSrcOne ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh SRC ALPHA", m_DeviceInfo.IsSrcSrcAlpha ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh SRC ALPHA SAT", m_DeviceInfo.IsSrcSrcAphaSat ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh SRC COLOR", m_DeviceInfo.IsSrcSrcColor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] \[Xuh ZERO", m_DeviceInfo.IsSrcZero ? "" : "~" );
	Luna::LogoutNextLine();

	Luna::LogoutStrong( "@fXguh\" );
	Luna::LogoutNextLine();

	Luna::Logout( "@@@[ %s ] fXguh BLEND FACTOR", m_DeviceInfo.IsDstBlendFactor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh BOTH INVSRC", m_DeviceInfo.IsDstBothInvSrc ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh BOTH SRC", m_DeviceInfo.IsDstBothSrc ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh DEST ALPHA", m_DeviceInfo.IsDstDestAlpha ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh DEST COLOR", m_DeviceInfo.IsDstDestColor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh INV DEST ALPHA", m_DeviceInfo.IsDstInvDestAlpha ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh INV DEST COLOR", m_DeviceInfo.IsDstInvDestColor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh INV SRC ALPHA", m_DeviceInfo.IsDstInvSrcAlpha ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh INV SRC COLOR", m_DeviceInfo.IsDstInvSrcColor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh ONE", m_DeviceInfo.IsDstOne ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh SRC ALPHA", m_DeviceInfo.IsDstSrcAlpha ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh SRC ALPHA SAT", m_DeviceInfo.IsDstSrcAphaSat ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh SRC COLOR", m_DeviceInfo.IsDstSrcColor ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] fXguh ZERO", m_DeviceInfo.IsDstZero ? "" : "~" );
	Luna::LogoutNextLine();

	Luna::LogoutStrong( "@eNX`\" );
	Luna::LogoutNextLine();

	Luna::Logout( "@@@[ %s ] L[u}bv", m_DeviceInfo.IsCubeTexture ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] ~bv}bv", m_DeviceInfo.IsMipmapTexture ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] p[XyNeBuRNg", m_DeviceInfo.IsPerspective ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] Qׂ̂ȊÕeNX`", m_DeviceInfo.IsPow2 ? "~" : "" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] `ȊÕeNX`", m_DeviceInfo.IsSquareOnly ? "~" : "" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] eNX` BORDER", m_DeviceInfo.IsTextureBorder ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] eNX` CLAMP", m_DeviceInfo.IsTxtureClamp ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] eNX` INDEPENDENT", m_DeviceInfo.IsTextureIndependent ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] eNX` MIRROR", m_DeviceInfo.IsTextureMirror ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] eNX` MIRROR RONCE", m_DeviceInfo.IsTextureMirrorRonce ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] eNX` WRAP", m_DeviceInfo.IsTextureWrap ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@eNX`ő剡 [ %u ]", m_DeviceInfo.MaxTextureWidth );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@eNX`őc [ %u ]", m_DeviceInfo.MaxTextureHeight );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@eNX`ő僊s[g [ %u ]", m_DeviceInfo.MaxTextureRepeat );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@eNX`őAXyNg [ %u ]", m_DeviceInfo.MaxTextureAspectRatio );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@eNX`ٕ̎ [ %u ]", m_DeviceInfo.MaxAnisotropy );
	Luna::LogoutNextLine();

	Luna::LogoutStrong( "@XeV\" );
	Luna::LogoutNextLine();

	Luna::Logout( "@@@[ %s ] XeV KEEP", m_DeviceInfo.IsStencilKeep ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] XeV ZERO", m_DeviceInfo.IsStencilZero ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] XeV REPLACE", m_DeviceInfo.IsStencilReplace ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] XeV INCRSAT", m_DeviceInfo.IsStencilIncRsat ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] XeV DECRSAT", m_DeviceInfo.IsStencilDecRsat ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] XeV INVERT", m_DeviceInfo.IsStencilInvert ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] XeV INCR", m_DeviceInfo.IsStencilIncR ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] XeV DECR", m_DeviceInfo.IsStencilDecR ? "" : "~" );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@[ %s ] XeV TWO SIDED", m_DeviceInfo.IsStencilTwoSided ? "" : "~" );
	Luna::LogoutNextLine();

	Luna::LogoutStrong( "@̑" );
	Luna::LogoutNextLine();

	Luna::Logout( "@@@ő傗l [ %lf ]", m_DeviceInfo.MaxVertexW );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@K[hoh@ [ %.3lf ]", m_DeviceInfo.GuardBandLeft );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@K[hoh@ [ %.3lf ]", m_DeviceInfo.GuardBandTop );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@K[hoh@E [ %.3lf ]", m_DeviceInfo.GuardBandRight );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@K[hoh@ [ %.3lf ]", m_DeviceInfo.GuardBandBottom );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@|CgTCY [ %.3lf ]", m_DeviceInfo.MaxPointSize );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őv~eBu [ %u ]", m_DeviceInfo.MaxPrimitiveCount );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őCfbNX [ %u ]", m_DeviceInfo.MaxVertexIndex );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őeNX`Xe[W [ %u ]", m_DeviceInfo.MaxTextureBlendStages );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@ő}`eNX` [ %u ]", m_DeviceInfo.MaxSimultaneousTextures );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őn[hEFACg [ %u ]", m_DeviceInfo.MaxActiveLights );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őuh}gbNX [ %u ]", m_DeviceInfo.MaxVertexBlendMatrices );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őuhCfbNX [ %u ]", m_DeviceInfo.MaxVertexBlendMatrixIndex );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@ő咸_VF[_[萔 [ %u ]", m_DeviceInfo.MaxVertexShaderConst );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@_VF[_[o[W [ %u.%u ]", D3DSHADER_VERSION_MAJOR(m_DeviceInfo.VertexShaderVersion), D3DSHADER_VERSION_MINOR(m_DeviceInfo.VertexShaderVersion) );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@sNZVF[_[o[W[ %u.%u ]", D3DSHADER_VERSION_MAJOR(m_DeviceInfo.PixelShaderVersion), D3DSHADER_VERSION_MINOR(m_DeviceInfo.PixelShaderVersion) );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@It[䖽߂̃lXeBO [ %u ]", m_DeviceInfo.DynamicFlowControlDepth );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@ÓIt[䖽߂̃lXeBO [ %u ]", m_DeviceInfo.StaticFlowControlDepth );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@ٕtB^Oő原 [ %u ]", m_DeviceInfo.MaxMaxAnisotropy );
	Luna::LogoutNextLine();

	Luna::LogoutNextLine();

	return true;
}

//=============================================================================
/**
	RcfoCX̐\擾܂B

	@param pCaps		[in] foCX̐\i[ꂽLpVeB\
	@param pDevInfo		[out] foCXi[p\̃AhX

*/
//=============================================================================
void Luna3D::GetDeviceCaps( D3DCAPS9 *pCaps, DEVICEINFORMATION *pDevInfo )
{
	//-----------------------------------------------------------
	// foCX
	//-----------------------------------------------------------

	// foCX^Cv
	pDevInfo->DeviceType				= pCaps->DeviceType;
	// sAfoCX
	pDevInfo->IsPureDevice				= ((pCaps->DevCaps & D3DDEVCAPS_PUREDEVICE) != 0);
	// n[hEFATnL
	pDevInfo->IsHardwareTnL				= ((pCaps->DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) != 0);
	// n[hEFARaster
	pDevInfo->IsSoftwareTnL				= ((pCaps->DevCaps & D3DDEVCAPS_HWRASTERIZATION) != 0);
	// fBUO
	pDevInfo->IsDither					= ((pCaps->RasterCaps & D3DPRASTERCAPS_DITHER) != 0);
	// [xoCAX
	pDevInfo->IsDepthBias				= ((pCaps->RasterCaps & D3DPRASTERCAPS_DEPTHBIAS) != 0);
	// vobt@
	pDevInfo->IsWBuffer					= ((pCaps->RasterCaps & D3DPRASTERCAPS_WBUFFER) != 0);
	// ~bv}bv
	pDevInfo->IsAutoMipMap				= ((pCaps->Caps2 & D3DCAPS2_CANAUTOGENMIPMAP) != 0);
	// yr
	pDevInfo->IsZCmpAlways				= ((pCaps->ZCmpCaps & D3DPCMPCAPS_ALWAYS) != 0);
	pDevInfo->IsZCmpEqual				= ((pCaps->ZCmpCaps & D3DPCMPCAPS_EQUAL) != 0);
	pDevInfo->IsZCmpGreater				= ((pCaps->ZCmpCaps & D3DPCMPCAPS_GREATER) != 0);
	pDevInfo->IsZCmpGreaterEqual		= ((pCaps->ZCmpCaps & D3DPCMPCAPS_GREATEREQUAL) != 0);
	pDevInfo->IsZCmpLess				= ((pCaps->ZCmpCaps & D3DPCMPCAPS_LESS) != 0);
	pDevInfo->IsZCmpLessEqual			= ((pCaps->ZCmpCaps & D3DPCMPCAPS_LESSEQUAL) != 0);
	pDevInfo->IsZCmpNever				= ((pCaps->ZCmpCaps & D3DPCMPCAPS_NEVER) != 0);
	pDevInfo->IsZCmpNotEqual			= ((pCaps->ZCmpCaps & D3DPCMPCAPS_NOTEQUAL) != 0);
	// At@uh^Cv
	pDevInfo->IsSrcBlendFactor			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_BLENDFACTOR) != 0);
	pDevInfo->IsSrcBothInvSrc			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_BOTHINVSRCALPHA) != 0);
	pDevInfo->IsSrcBothSrc				= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_BOTHSRCALPHA) != 0);
	pDevInfo->IsSrcDestAlpha			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_DESTALPHA) != 0);
	pDevInfo->IsSrcDestColor			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_DESTCOLOR) != 0);
	pDevInfo->IsSrcInvDestAlpha			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_INVDESTALPHA) != 0);
	pDevInfo->IsSrcInvDestColor			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_INVDESTCOLOR) != 0);
	pDevInfo->IsSrcInvSrcAlpha			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_INVSRCALPHA) != 0);
	pDevInfo->IsSrcInvSrcColor			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_INVSRCCOLOR) != 0);
	pDevInfo->IsSrcOne					= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_ONE) != 0);
	pDevInfo->IsSrcSrcAlpha				= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_SRCALPHA) != 0);
	pDevInfo->IsSrcSrcAphaSat			= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_SRCALPHASAT) != 0);
	pDevInfo->IsSrcSrcColor				= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_SRCCOLOR) != 0);
	pDevInfo->IsSrcZero					= ((pCaps->SrcBlendCaps & D3DPBLENDCAPS_ZERO) != 0);
	// At@uh^C	v
	pDevInfo->IsDstBlendFactor			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_BLENDFACTOR) != 0);
	pDevInfo->IsDstBothInvSrc			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_BOTHINVSRCALPHA) != 0);
	pDevInfo->IsDstBothSrc				= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_BOTHSRCALPHA) != 0);
	pDevInfo->IsDstDestAlpha			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_DESTALPHA) != 0);
	pDevInfo->IsDstDestColor			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_DESTCOLOR) != 0);
	pDevInfo->IsDstInvDestAlpha			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_INVDESTALPHA) != 0);
	pDevInfo->IsDstInvDestColor			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_INVDESTCOLOR) != 0);
	pDevInfo->IsDstInvSrcAlpha			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_INVSRCALPHA) != 0);
	pDevInfo->IsDstInvSrcColor			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_INVSRCCOLOR) != 0);
	pDevInfo->IsDstOne					= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_ONE) != 0);
	pDevInfo->IsDstSrcAlpha				= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_SRCALPHA) != 0);
	pDevInfo->IsDstSrcAphaSat			= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_SRCALPHASAT) != 0);
	pDevInfo->IsDstSrcColor				= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_SRCCOLOR) != 0);
	pDevInfo->IsDstZero					= ((pCaps->DestBlendCaps & D3DPBLENDCAPS_ZERO) != 0);
	// eNX`
	pDevInfo->IsCubeTexture				= ((pCaps->TextureCaps & D3DPTEXTURECAPS_CUBEMAP) != 0);
	pDevInfo->IsMipmapTexture			= ((pCaps->TextureCaps & D3DPTEXTURECAPS_MIPMAP) != 0);
	pDevInfo->IsPerspective				= ((pCaps->TextureCaps & D3DPTEXTURECAPS_PERSPECTIVE) != 0);
	pDevInfo->IsPow2					= ((pCaps->TextureCaps & D3DPTEXTURECAPS_POW2) != 0);
	pDevInfo->IsPow2Conditional			= ((pCaps->TextureCaps & D3DPTEXTURECAPS_NONPOW2CONDITIONAL) != 0);
	pDevInfo->IsSquareOnly				= ((pCaps->TextureCaps & D3DPTEXTURECAPS_SQUAREONLY) != 0);
	// eNX`AhVO
	pDevInfo->IsTextureBorder			= ((pCaps->TextureAddressCaps & D3DPTADDRESSCAPS_BORDER) != 0);
	pDevInfo->IsTxtureClamp				= ((pCaps->TextureAddressCaps & D3DPTADDRESSCAPS_CLAMP) != 0);
	pDevInfo->IsTextureIndependent		= ((pCaps->TextureAddressCaps & D3DPTADDRESSCAPS_INDEPENDENTUV) != 0);
	pDevInfo->IsTextureMirror			= ((pCaps->TextureAddressCaps & D3DPTADDRESSCAPS_MIRROR) != 0);
	pDevInfo->IsTextureMirrorRonce		= ((pCaps->TextureAddressCaps & D3DPTADDRESSCAPS_MIRRORONCE) != 0);
	pDevInfo->IsTextureWrap				= ((pCaps->TextureAddressCaps & D3DPTADDRESSCAPS_WRAP) != 0);
	// eNX`
	pDevInfo->MaxTextureWidth			= pCaps->MaxTextureWidth;
	pDevInfo->MaxTextureHeight			= pCaps->MaxTextureHeight;
	pDevInfo->MaxTextureRepeat			= pCaps->MaxTextureRepeat;
	pDevInfo->MaxTextureAspectRatio		= pCaps->MaxTextureAspectRatio;
	pDevInfo->MaxAnisotropy				= pCaps->MaxAnisotropy;
	// XeV
	pDevInfo->IsStencilKeep				= ((pCaps->StencilCaps & D3DSTENCILCAPS_KEEP) != 0);
	pDevInfo->IsStencilZero				= ((pCaps->StencilCaps & D3DSTENCILCAPS_ZERO) != 0);
	pDevInfo->IsStencilReplace			= ((pCaps->StencilCaps & D3DSTENCILCAPS_REPLACE) != 0);
	pDevInfo->IsStencilIncRsat			= ((pCaps->StencilCaps & D3DSTENCILCAPS_INCRSAT) != 0); 
	pDevInfo->IsStencilDecRsat			= ((pCaps->StencilCaps & D3DSTENCILCAPS_DECRSAT) != 0); 
	pDevInfo->IsStencilInvert			= ((pCaps->StencilCaps & D3DSTENCILCAPS_INVERT) != 0);
	pDevInfo->IsStencilIncR				= ((pCaps->StencilCaps & D3DSTENCILCAPS_INCR) != 0);
	pDevInfo->IsStencilDecR				= ((pCaps->StencilCaps & D3DSTENCILCAPS_DECR) != 0);
	pDevInfo->IsStencilTwoSided			= ((pCaps->StencilCaps & D3DSTENCILCAPS_TWOSIDED) != 0);
	// 
	pDevInfo->MaxVertexW				= pCaps->MaxVertexW;
	pDevInfo->GuardBandLeft				= pCaps->GuardBandLeft;
	pDevInfo->GuardBandTop				= pCaps->GuardBandTop;
	pDevInfo->GuardBandRight			= pCaps->GuardBandRight;
	pDevInfo->GuardBandBottom			= pCaps->GuardBandBottom;
	pDevInfo->MaxPointSize				= pCaps->MaxPointSize;
	pDevInfo->MaxPrimitiveCount			= pCaps->MaxPrimitiveCount;
	pDevInfo->MaxVertexIndex			= pCaps->MaxVertexIndex;
	pDevInfo->MaxMaxAnisotropy			= pCaps->MaxAnisotropy;
	// eNX`
	pDevInfo->MaxTextureBlendStages		= pCaps->MaxTextureBlendStages;
	pDevInfo->MaxSimultaneousTextures	= pCaps->MaxSimultaneousTextures;
	// Cg
	pDevInfo->MaxActiveLights			= pCaps->MaxActiveLights;
	// {[
	pDevInfo->MaxVertexBlendMatrices	= pCaps->MaxVertexBlendMatrices;
	pDevInfo->MaxVertexBlendMatrixIndex	= pCaps->MaxVertexBlendMatrixIndex;
	// VF[_[
	pDevInfo->VertexShaderVersion		= pCaps->VertexShaderVersion;
	pDevInfo->PixelShaderVersion		= pCaps->PixelShaderVersion;
	pDevInfo->MaxVertexShaderConst		= pCaps->MaxVertexShaderConst;
	pDevInfo->DynamicFlowControlDepth	= pCaps->VS20Caps.DynamicFlowControlDepth;
	pDevInfo->StaticFlowControlDepth	= pCaps->VS20Caps.StaticFlowControlDepth;
}

//=============================================================================
/**
	Rc֌W̃foCXN܂B

	@param hWindow		[in] EBhEnh
	@param IsWindow		[in] EBhE[h̎ true w

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::Start( HWND hWindow, Bool IsWindow )
{
	HRESULT hr = E_FAIL;

	Luna::LogoutMainCategory( "Luna3DNX̋N" );
	Luna::LogoutNextLine();

	//-----------------------------------------------------------
	// foCX^Cv̐ݒ
	//-----------------------------------------------------------
	Sint32 DeviceNo = Luna3D::GetDeviceTypeNo();

	//-----------------------------------------------------------
	// foCXpp[^[̐ݒ
	//-----------------------------------------------------------
	m_PresentParams[0] = MakePresentParameters( hWindow, true, false );
	m_PresentParams[1] = MakePresentParameters( hWindow, false, m_IsFullColor );

	D3DPRESENT_PARAMETERS PresentParam = m_PresentParams[IsWindow ? 0 : 1];

	//-----------------------------------------------------------
	// RcfoCX̐
	//-----------------------------------------------------------
	Luna::LogoutStrong( "@Direct3DfoCX̐" );
	Luna::LogoutNextLine();

	if ( !CreateDeviceByNVPerfHUD( hWindow, &PresentParam ) )
	{
		do
		{
			// foCX
			hr = m_pDirect3D->CreateDevice(
								D3DADAPTER_DEFAULT,
								DeviceType[DeviceNo],
								hWindow,
								CreateFlag[DeviceNo] | D3DCREATE_MULTITHREADED,
								&PresentParam,
								&m_pDevice );
			if SUCCEEDED( hr ) break;
		}
		while ( ++DeviceNo < 5 );

		// foCXI
		switch ( DeviceNo )
		{
		case 0:
			Luna::Logout( "@@@Direct3DfoCX [ D3DDEVTYPE_HAL ] [ D3DCREATE_MIXED_VERTEXPROCESSING ] Ő" );
			Luna::LogoutNextLine();
			break;
		case 1:
			Luna::Logout( "@@@Direct3DfoCX [ D3DDEVTYPE_HAL ] [ D3DCREATE_SOFTWARE_VERTEXPROCESSING ] Ő" );
			Luna::LogoutNextLine();
			break;
		case 2:
			Luna::Logout( "@@@Direct3DfoCX [ D3DDEVTYPE_REF ] [ D3DCREATE_SOFTWARE_VERTEXPROCESSING ] Ő" );
			Luna::LogoutNextLine();
			break;
		default:
			Luna::LogoutError( "@@@G[FfoCX̍쐬Ɏs [ %s ]", Luna3D::GetError(hr) );
			Luna::LogoutNextLine();
			Luna::LogoutError( "@@@@@@FDirectX̃G[Ŗꍇ͑̃\tgrfIJ[hLĂ\܂B" );
			Luna::LogoutNextLine();
			return false;
		}
	}

	//-----------------------------------------------------------
	// VRAM
	//-----------------------------------------------------------
	Luna::LogoutStrong( "@ceNX`e <%4dMB>", Luna3D::GetRestVRAM() );
	Luna::LogoutNextLine();

	//-----------------------------------------------------------
	// IDirect3DQuery9C^[tF[X擾
	//-----------------------------------------------------------
	// Cxg擾p
	hr = m_pDevice->CreateQuery( D3DQUERYTYPE_EVENT, &m_pQuery[0] );
	if FAILED( hr )
	{
		Luna::LogoutError( "@@@G[FIDirect3DQuery9C^[tF[X̎擾Ɏs [ %s ]", Luna3D::GetError(hr) );
		Luna::LogoutNextLine();
	}

	// sNZtB[g擾p
	hr = m_pDevice->CreateQuery( D3DQUERYTYPE_OCCLUSION, &m_pQuery[1] );
	if FAILED( hr )
	{
		Luna::LogoutError( "@@@G[FIDirect3DQuery9C^[tF[X̎擾Ɏs [ %s ]", Luna3D::GetError(hr) );
		Luna::LogoutNextLine();
	}

	//-----------------------------------------------------------
	// _O^[Qbg擾
	//-----------------------------------------------------------
	m_pDevice->GetRenderTarget( 0, &m_pRenderTarget );

	//-----------------------------------------------------------
	// foCXݒ
	//-----------------------------------------------------------
	InitializeDeviceSetteing();
	ResetDeviceSetteing();

	//-----------------------------------------------------------
	// ݂̃foCX̐\擾
	//-----------------------------------------------------------
	D3DCAPS9 Caps;
	m_pDevice->GetDeviceCaps( &Caps );
	GetDeviceCaps( &Caps, &m_DeviceInfo );

	Luna::LogoutStrong( "@݂̃foCX擾" );
	Luna::LogoutNextLine();

	Luna::Logout( "@@@|CgTCY [ %.3lf ]", m_DeviceInfo.MaxPointSize );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őv~eBu [ %u ]", m_DeviceInfo.MaxPrimitiveCount );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őCfbNX [ %u ]", m_DeviceInfo.MaxVertexIndex );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őeNX`Xe[W [ %u ]", m_DeviceInfo.MaxTextureBlendStages );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@ő}`eNX` [ %u ]", m_DeviceInfo.MaxSimultaneousTextures );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őn[hEFACg [ %u ]", m_DeviceInfo.MaxActiveLights );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őuh}gbNX [ %u ]", m_DeviceInfo.MaxVertexBlendMatrices );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@őuhCfbNX [ %u ]", m_DeviceInfo.MaxVertexBlendMatrixIndex );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@ő咸_VF[_[萔 [ %u ]", m_DeviceInfo.MaxVertexShaderConst );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@_VF[_[o[W [ %u.%u ]", D3DSHADER_VERSION_MAJOR(m_DeviceInfo.VertexShaderVersion), D3DSHADER_VERSION_MINOR(m_DeviceInfo.VertexShaderVersion) );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@sNZVF[_[o[W[ %u.%u ]", D3DSHADER_VERSION_MAJOR(m_DeviceInfo.PixelShaderVersion), D3DSHADER_VERSION_MINOR(m_DeviceInfo.PixelShaderVersion) );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@It[䖽߂̃lXeBO [ %u ]", m_DeviceInfo.DynamicFlowControlDepth );
	Luna::LogoutNextLine();
	Luna::Logout( "@@@ÓIt[䖽߂̃lXeBO [ %u ]", m_DeviceInfo.StaticFlowControlDepth );
	Luna::LogoutNextLine();

	Luna::LogoutNextLine();

	return true;
}

//=============================================================================
/**
	foCXݒ̏܂

*/
//=============================================================================
Bool Luna3D::CreateDeviceByNVPerfHUD( HWND hWindow, D3DPRESENT_PARAMETERS *pPresentParam )
{
	if ( m_IsNVPerfHUD )
	{
		for ( Uint32 Adapter = 0; Adapter < m_pDirect3D->GetAdapterCount(); Adapter++ )
		{
			D3DADAPTER_IDENTIFIER9 Identifier;
			
			m_pDirect3D->GetAdapterIdentifier( Adapter, 0, &Identifier );
			if ( !strcmp( Identifier.Description, "NVIDIA NVPerfHUD" ) )
			{
				HRESULT hr = m_pDirect3D->CreateDevice(
									Adapter,
									D3DDEVTYPE_REF,
									hWindow,
									D3DCREATE_MIXED_VERTEXPROCESSING | D3DCREATE_MULTITHREADED,
									pPresentParam,
									&m_pDevice );
				if SUCCEEDED( hr )
				{
					Luna::Logout( "@@@Direct3DfoCX [ NVPerfHUDp ] Ő" );
					Luna::LogoutNextLine();

					return true;
				}
			}
		}
	}

	return false;
}

//=============================================================================
/**
	foCXݒ̏܂

*/
//=============================================================================
void Luna3D::InitializeDeviceSetteing( void )
{
	Sint32 Width, Height;
	Luna::GetScreenData( &Width, &Height, NULL );
	// r[|[gl
	m_Viewport.X			= 0;
	m_Viewport.Y			= 0;
	m_Viewport.Width		= Width;
	m_Viewport.Height		= Height;
    m_Viewport.MinZ			= 0.0000000000000000000000001f;
	m_Viewport.MaxZ			= 1.0000000000000000000000000f;

	// eT[tFCX
	m_lTexTarget			= INVALID_TEXTURE;
	m_lSurfTarget			= INVALID_SURFACE;
	m_lSurfDepthStencil		= INVALID_SURFACE;
	m_lCamera				= INVALID_CAMERA;

	// _[Xe[g
	MemoryFill( m_RenderState, 0xFF, sizeof(m_RenderState) );
	for ( Uint32 i = 0; i < RenderStateTblCount; i++ )
	{
		m_pDevice->GetRenderState( RenderStateTbl[i], &m_RenderState[RenderStateTbl[i]] );
	}

	// eNX`Xe[g
	MemoryFill( m_TextureState, 0xFF, sizeof(m_TextureState) );
	for ( Uint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
	{
		for ( Uint32 j = 0; j < TextureStateTblCount; j++ )
		{
			m_pDevice->GetTextureStageState( i, TextureStateTbl[j], &m_TextureState[i][TextureStateTbl[j]] );
		}
	}

	// Tv[Xe[g
	MemoryFill( m_SamplerState, 0xFF, sizeof(m_SamplerState) );
	for ( Uint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
	{
		for ( Uint32 j = 0; j < SamplerStateTblCount; j++ )
		{
			m_pDevice->GetSamplerState( i, SamplerStateTbl[j], &m_SamplerState[i][SamplerStateTbl[j]] );
		}
	}

	//@_OXe[g
	Luna3D::SetRenderState( D3DRS_LIGHTING, false );
	Luna3D::SetRenderState( D3DRS_ZENABLE, false );
	Luna3D::SetRenderState( D3DRS_ZWRITEENABLE, false );
	Luna3D::SetRenderState( D3DRS_ALPHABLENDENABLE, true );
	Luna3D::SetRenderState( D3DRS_ALPHATESTENABLE, false );
	Luna3D::SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

	for ( Sint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
	{
		// Tv[Xe[g
		Luna3D::SetSamplerState( i, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP );
		Luna3D::SetSamplerState( i, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP );
		Luna3D::SetSamplerState( i, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
		Luna3D::SetSamplerState( i, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
		Luna3D::SetSamplerState( i, D3DSAMP_MIPFILTER, D3DTEXF_LINEAR );
		Luna3D::SetSamplerState( i, D3DSAMP_MAXANISOTROPY, m_DeviceInfo.MaxAnisotropy );

		// eNX`Xe[g
		Luna3D::SetTextureState( i, D3DTSS_COLOROP, (i==0)?(D3DTOP_MODULATE):(D3DTOP_DISABLE) );
		Luna3D::SetTextureState( i, D3DTSS_COLORARG1, D3DTA_TEXTURE );
		Luna3D::SetTextureState( i, D3DTSS_COLORARG2, D3DTA_CURRENT );

		Luna3D::SetTextureState( i, D3DTSS_ALPHAOP, (i==0)?(D3DTOP_MODULATE):(D3DTOP_DISABLE) );
		Luna3D::SetTextureState( i, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
		Luna3D::SetTextureState( i, D3DTSS_ALPHAARG2, D3DTA_CURRENT );
	}

	// }eApftHg
	for ( Uint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
	{
		for ( Uint32 j = 0; j < TextureStateTblCount; j++ )
		{
			m_DefaultState.TextureState[i][TextureStateTbl[j]] = m_TextureState[i][TextureStateTbl[j]];
		}

		for ( Uint32 j = 0; j < SamplerStateTblCount; j++ )
		{
			m_DefaultState.SamplerState[i][SamplerStateTbl[j]] = m_SamplerState[i][SamplerStateTbl[j]];
		}
	}

	m_DefaultState.BlendType	= BLEND_NONE;
	m_DefaultState.IsColorKey	= true;
	m_DefaultState.IsBilinear	= true;
	m_DefaultState.IsZBuffer	= true;
	m_DefaultState.IsZWrite		= true;
}

//=============================================================================
/**
	foCXݒ̏܂

*/
//=============================================================================
void Luna3D::ResetDeviceSetteing( void )
{
	//------------------------------------------------------------------
	// r[|[gݒ
	//------------------------------------------------------------------
	m_pDevice->SetViewport( &m_Viewport );

	//------------------------------------------------------------------
	// _O^[QbgeNX`
	//------------------------------------------------------------------
	if ( m_lTexTarget != NULL )
	{
		((CTexture*)m_lTexTarget)->SetRenderTarget();
	}

	//------------------------------------------------------------------
	// _O^[QbgT[tFCX
	//------------------------------------------------------------------
	if ( m_lSurfTarget != NULL )
	{
		((CSurface*)m_lSurfTarget)->SetRenderTarget();
	}

	//------------------------------------------------------------------
	// [xXeVT[tFCX
	//------------------------------------------------------------------
	if ( m_lSurfDepthStencil != NULL )
	{
		((CSurface*)m_lSurfDepthStencil)->SetDepthStencil();
	}

	//------------------------------------------------------------------
	// J
	//------------------------------------------------------------------
	if ( m_lCamera != INVALID_CAMERA )
	{
		LunaCamera::SetDevice( m_lCamera );
	}

	//------------------------------------------------------------------
	// _OXe[g
	//------------------------------------------------------------------
	for ( Uint32 i = 0; i < RenderStateTblCount; i++ )
	{
		m_pDevice->SetRenderState( RenderStateTbl[i], m_RenderState[RenderStateTbl[i]] );
	}

	//------------------------------------------------------------------
	// eNX`[Xe[g
	//------------------------------------------------------------------
	for ( Uint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
	{
		for ( Uint32 j = 0; j < TextureStateTblCount; j++ )
		{
			m_pDevice->SetTextureStageState( i, TextureStateTbl[j], m_TextureState[i][TextureStateTbl[j]] );
		}
	}

	//------------------------------------------------------------------
	// Tv[Xe[g
	//------------------------------------------------------------------
	for ( Uint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
	{
		for ( Uint32 j = 0; j < SamplerStateTblCount; j++ )
		{
			m_pDevice->SetSamplerState( i, SamplerStateTbl[j], m_SamplerState[i][SamplerStateTbl[j]] );
		}
	}

	//------------------------------------------------------------------
	// obNobt@NA
	//------------------------------------------------------------------
	Luna3D::Clear( D3DCLEAR_TARGET );
}

//=============================================================================
/**
	G~[V[hŋN悤ɂ܂B

*/
//=============================================================================
void Luna3D::EnableEmulationMode( void )
{
	m_IsEmulationMode = true;
}

//=============================================================================
/**
	G~[V[hgp悤ɂ܂B

*/
//=============================================================================
void Luna3D::EnableFullColorMode( void )
{
	m_IsFullColor = true;
}

//=============================================================================
/**
	ʂ̍XVɐX悤ɂȂ܂B

*/
//=============================================================================
void Luna3D::EnableWaitVBlank( void )
{
	m_IsWaitBlank = true;
}

//=============================================================================
/**
	ʂ̍XVɐX悤ɂȂ܂B

*/
//=============================================================================
void Luna3D::EnableNVPerfHUD( void )
{
	m_IsNVPerfHUD = true;
}

//=============================================================================
/**
	foCX̃^Cvԍ擾܂B

	@retval 0		PureDevice
	@retval 1		Hardware & Spftware TnL
	@retval 2		Hardware & Spftware TnL
	@retval 3		Software TnL
	@retval 4		Reference Rasterizer
*/
//=============================================================================
Sint32 Luna3D::GetDeviceTypeNo( void )
{
	Sint32 No = 2;		// REF

	// G~[V[hH
	if ( m_IsEmulationMode ) return No;

	// n[hEFAX^CYT|[gH
	if ( !m_DeviceInfo.IsSoftwareTnL ) return No;

	No--;

	// n[hEFAskT|[gH
	if ( !m_DeviceInfo.IsHardwareTnL ) return No;

	No--;

	return No;
}


//=============================================================================
/**
	gpv[e[Vp[^[擾܂B

	@param hWnd				[in] EBhEnh
	@param IsWindow			[in] true ̎ EBhE[h / false ̎ tXN[[h
	@param IsFullColor		[in] true ̎ 32Bit[h / false ̎ 16Bit[h

	@return			ꂽv[e[Vp[^[\
*/
//=============================================================================
D3DPRESENT_PARAMETERS Luna3D::MakePresentParameters( HWND hWnd, Bool IsWindow, Bool IsFullColor )
{
	Sint32 Width, Height;
	D3DPRESENT_PARAMETERS PresentParam;
	D3DFORMAT DepthFormat = D3DFMT_UNKNOWN;
	D3DFORMAT ScreenFormat = IsWindow ? m_WindowMode.Format : m_FullScreenMode[IsFullColor ? 1 : 0].Format;

	//-----------------------------------------------------------
	// ʃTCY擾
	//-----------------------------------------------------------
	Luna::GetScreenData( &Width, &Height, NULL );

	//-----------------------------------------------------------
	// LȃtH[}bg擾
	//-----------------------------------------------------------
	for ( Sint32 i = 0; i < 8; i++ )
	{
		if ( BackBufferFormats[i] == ScreenFormat )
		{
			DepthFormat = m_AdapterData.DepthFormats[0];
		}
	}

	//-----------------------------------------------------------
	// p[^[
	//-----------------------------------------------------------
	PresentParam.BackBufferWidth			= Width;
	PresentParam.BackBufferHeight			= Height;
	PresentParam.BackBufferFormat			= ScreenFormat;
	PresentParam.BackBufferCount			= 1;
	PresentParam.MultiSampleType			= m_MultiSampleType;
	PresentParam.MultiSampleQuality			= m_MultiSampleQuality;
	PresentParam.SwapEffect					= D3DSWAPEFFECT_DISCARD;
	PresentParam.hDeviceWindow				= hWnd;
	PresentParam.Windowed					= IsWindow;
	PresentParam.EnableAutoDepthStencil		= false;
	PresentParam.AutoDepthStencilFormat		= DepthFormat;
	PresentParam.Flags						= D3DPRESENTFLAG_LOCKABLE_BACKBUFFER;
	PresentParam.FullScreen_RefreshRateInHz	= D3DPRESENT_RATE_DEFAULT;
	PresentParam.PresentationInterval		= m_IsWaitBlank ? D3DPRESENT_INTERVAL_ONE : D3DPRESENT_INTERVAL_IMMEDIATE;

	return PresentParam;
}

//=============================================================================
/**
	RcfoCX̃Zbg܂B

	@param IsChange		[in] true ̎Aʃ[h؂ւ܂
*/
//=============================================================================
void Luna3D::ResetDevice( Bool IsChange )
{
	HRESULT hr;

	//-------------------------------------------------------
	// foCX܂ĂȂꍇ͏I
	//-------------------------------------------------------
	if ( m_pDevice == NULL ) return;

	//-------------------------------------------------------
	// XN[[h̕ύXłȂAfoCXȂȂI
	//-------------------------------------------------------
	if ( !IsChange && (m_pDevice->TestCooperativeLevel() == D3D_OK) ) return;

	//-------------------------------------------------------
	// v[e[Vp[^擾
	//-------------------------------------------------------
	Sint32 Width, Height;
	Bool IsWindow;
	Luna::GetScreenData( &Width, &Height, &IsWindow );
	m_PresentParams[0].BackBufferWidth		= Width;
	m_PresentParams[0].BackBufferHeight	= Height;
	m_PresentParams[1].BackBufferWidth		= Width;
	m_PresentParams[1].BackBufferHeight	= Height;

	D3DPRESENT_PARAMETERS PresentParam = m_PresentParams[IsWindow ? 0 : 1];

	//-------------------------------------------------------
	// rfĨ\[XS
	//-------------------------------------------------------
	LunaTexture::Reset();
	LunaVMR9::Reset();
	LunaSurface::Reset();
	LunaSprite::Reset();
	LunaSprite3D::Reset();
	LunaPrimitive::Reset();
	LunaPrimitive3D::Reset();
	LunaLine::Reset();
	LunaLine3D::Reset();
	LunaPoint::Reset();
	LunaPoint3D::Reset();
	LunaModel::Reset();
	LunaModelEx::Reset();
	LunaField::Reset();
	LunaSimple::Reset();
	LunaShaderFx::Reset();

	SAFE_RELEASE( m_pQuery[0] );
	SAFE_RELEASE( m_pQuery[1] );
	SAFE_RELEASE( m_pRenderTarget );

	if ( m_pCallbackReset != NULL )
	{
		m_pCallbackReset();
	}

	//-------------------------------------------------------
	// foCX̃Zbg
	//-------------------------------------------------------
	if FAILED( m_pDevice->Reset( &PresentParam ) )
	{
		Luna::MsgBox( MB_ICONERROR, "ERROR", "foCX̕AɎs" );
	}

	m_pDevice->GetRenderTarget( 0, &m_pRenderTarget );

	//-------------------------------------------------------
	// IDirect3DQuery9C^[tF[X擾
	//-------------------------------------------------------
	// Cxg擾p
	hr = m_pDevice->CreateQuery( D3DQUERYTYPE_EVENT, &m_pQuery[0] );
	if FAILED( hr )
	{
		Luna::LogoutError( "@@@G[FIDirect3DQuery9C^[tF[X̎擾Ɏs [ %s ]", Luna3D::GetError(hr) );
		Luna::LogoutNextLine();
	}

	// sNZtB[g擾p
	hr = m_pDevice->CreateQuery( D3DQUERYTYPE_OCCLUSION, &m_pQuery[1] );
	if FAILED( hr )
	{
		Luna::LogoutError( "@@@G[FIDirect3DQuery9C^[tF[X̎擾Ɏs [ %s ]", Luna3D::GetError(hr) );
		Luna::LogoutNextLine();
	}

	m_IsCheckingFillRate = false;

	//-------------------------------------------------------
	// rfĨ\[XS
	//-------------------------------------------------------
	LunaTexture::Restore();
	LunaVMR9::Restore();
	LunaSurface::Restore();
	LunaSprite::Restore();
	LunaSprite3D::Restore();
	LunaPrimitive::Restore();
	LunaPrimitive3D::Restore();
	LunaLine::Restore();
	LunaLine3D::Restore();
	LunaPoint::Restore();
	LunaPoint3D::Restore();
	LunaModel::Restore();
	LunaModelEx::Restore();
	LunaField::Restore();
	LunaSimple::Restore();
	LunaShaderFx::Restore();

	if ( m_pCallbackRestore != NULL )
	{
		m_pCallbackRestore();
	}

	//-------------------------------------------------------
	// foCX̐ݒ𕜋A
	//-------------------------------------------------------
	Luna3D::ResetDeviceSetteing();
}

//=============================================================================
/*
	foCXXg̃f[^ZbgpR[obN֐ݒ

	@param pCallback		[in] R[obN֐

*/
//=============================================================================
void Luna3D::SetCallbackDeviceReset( void (*pCallback)( void ) )
{
	m_pCallbackReset = pCallback;
}

//=============================================================================
/*
	foCXXg̃f[^XgApR[obN֐ݒ

	@param pCallback		[in] R[obN֐

*/
//=============================================================================
void Luna3D::SetCallbackDeviceRestore( void (*pCallback)( void ) )
{
	m_pCallbackRestore = pCallback;
}

//=============================================================================
/*
	gpRcfoCX̃foCX擾܂B

	@param pInfo		[in] foCXi[AhX

*/
//=============================================================================
void Luna3D::GetDeviceInformation( DEVICEINFORMATION *pInfo )
{
	MemoryCopy( pInfo, &m_DeviceInfo, sizeof(DEVICEINFORMATION) );
}

//=============================================================================
/**
	gpĂRcfoCX擾܂B

	@return		RcfoCXIuWFNg
*/
//=============================================================================
HMONITOR Luna3D::GetAdapterMonitor( void )
{
	return m_pDirect3D->GetAdapterMonitor( D3DADAPTER_DEFAULT );
}

//=============================================================================
/**
	gpĂRcfoCX擾܂B

	@return		RcfoCXIuWFNg
*/
//=============================================================================
IDirect3DDevice9 *Luna3D::GetDevice( void )
{
	return m_pDevice;
}

//=============================================================================
/**
	sNZVF[_[̃T|[g`FbN܂

	@param Major		[in] W[o[W
	@param Minor		[in] }Ci[o[W

	@retval true		T|[gĂ
	@retval false		T|[gĂȂ
*/
//=============================================================================
Bool Luna3D::CheckPixelShaderSupport( Uint16 Major, Uint16 Minor )
{
	return (D3DPS_VERSION(Major,Minor) <= m_DeviceInfo.PixelShaderVersion);
}

//=============================================================================
/**
	gp钸_VF[_[̍ōo[Wݒ

	@param Major		[in] W[o[W
	@param Minor		[in] }Ci[o[W

*/
//=============================================================================
void Luna3D::SetMaxVertexShaderViersion( Uint16 Major, Uint16 Minor )
{
	m_MaxVertexShaderVersion = D3DVS_VERSION(Major,Minor);
}

//=============================================================================
/**
	_VF[_[̃T|[g`FbN܂

	@param Major		[in] W[o[W
	@param Minor		[in] }Ci[o[W

	@retval true		T|[gĂ
	@retval false		T|[gĂȂ
*/
//=============================================================================
void Luna3D::SetVertexProccessing( Uint16 Major, Uint16 Minor )
{
	if ( m_IsEmulationMode )
	{
		m_pDevice->SetSoftwareVertexProcessing( true );
	}
	else
	{
		if ( GetVertexProccessing( Major, Minor ) )
		{
			m_pDevice->SetSoftwareVertexProcessing( true );
		}
		else
		{
			m_pDevice->SetSoftwareVertexProcessing( false );
		}
	}
}

//=============================================================================
/**
	_^Cv擾܂

	@param Major		[in] _VF[_[̃W[o[W
	@param Minor		[in] _VF[_[̃}Ci[o[W

	@retval true		n[hEFAskŏ
	@retval false		\tgEFAskŏ
*/
//=============================================================================
Bool Luna3D::GetVertexProccessing( Uint16 Major, Uint16 Minor )
{
	if ( m_DeviceInfo.IsHardwareTnL )
	{
		if ( D3DVS_VERSION(Major,Minor) <= m_DeviceInfo.VertexShaderVersion )
		{
			return false;
		}
		else
		{
			return true;
		}
	}
	else
	{
		return true;
	}
}


//=============================================================================
/**
	~bv}bvT|[gĂ邩𒲂ׂ܂B

	@param Format	[in] ׂT[tFCXtH[}bg
	@param IsMipmap	[in] ~bv}bvgp邩ۂ

	@return T|[gtrue
*/
//=============================================================================
Bool Luna3D::GetAutoGenerateMipmapEnable( D3DFORMAT Format, Bool IsMipmap )
{
	if ( IsMipmap )
	{
		for ( Sint32 i = 0; i < m_AdapterData.TextureCount; i++ )
		{
			if ( m_AdapterData.TextureFormats[i] == Format )
			{
				if ( m_AdapterData.TextureMipmap[i] )
				{
					return true;
				}
			}
		}
	}

	return false;
}


//=============================================================================
/**
	_OɎgpr[|[gݒ肵܂

	@param pRect	[in] r[|[g`\̂ւ̃|C^
*/
//=============================================================================
void Luna3D::SetViewport( RECT *pRect )
{
	RECT Rect = { 0, 0, 0, 0 };
	if ( pRect == NULL )
	{
		pRect = &Rect;
		Luna::GetScreenData( &Rect.right, &Rect.bottom, NULL );
	}

	m_Viewport.X		= pRect->left;
	m_Viewport.Y		= pRect->top;
	m_Viewport.Width	= pRect->right - pRect->left;
	m_Viewport.Height	= pRect->bottom - pRect->top;
	m_Viewport.MinZ		= 0.0f;
	m_Viewport.MaxZ		= 1.0f;

	m_pDevice->SetViewport( &m_Viewport );
}

//=============================================================================
/**
	_OɎgpĂr[|[g擾܂

	@param pRect	[in] r[|[g`\̂ւ̃|C^
*/
//=============================================================================
void Luna3D::GetViewport( RECT *pRect )
{
	pRect->left   = m_Viewport.X;
	pRect->top    = m_Viewport.Y;
	pRect->right  = m_Viewport.X + m_Viewport.Width;
	pRect->bottom = m_Viewport.Y + m_Viewport.Height;
}

//=============================================================================
/**
	_OXe[gfoCXɐݒ肵܂B<BR>
	p[^[֌WDirectX9̃wvQƂĂB

	@param State	[in] ݒ肷Xe[g^Cv
	@param Param	[in] p[^
*/
//=============================================================================
void Luna3D::SetRenderState( D3DRENDERSTATETYPE State, Uint32 Param )
{
	if ( m_RenderState[State] != Param )
	{
		m_RenderState[State] = Param;
		m_pDevice->SetRenderState( State, Param );
	}
}

//=============================================================================
/**
	eNX`Xe[gfoCXɐݒ肵܂<BR>
	p[^[֌WDirectX9̃wvQƂĂB

	@param Stage	[in] ݒ肷Xe[W
	@param State	[in] ݒ肷Xe[g^Cv
	@param Param	[in] p[^
*/
//=============================================================================
void Luna3D::SetTextureState( Uint32 Stage, D3DTEXTURESTAGESTATETYPE State, Uint32 Param )
{
	if ( (0 <= Stage) && (Stage < TEXTURE_STAGE_MAX) )
	{
		if ( m_TextureState[Stage][State] != Param )
		{
			m_TextureState[Stage][State] = Param;
			m_pDevice->SetTextureStageState( Stage, State, Param );
		}
	}
}

//=============================================================================
/**
	Tv[Xe[gfoCXɐݒ肵܂<BR>
	p[^[֌WDirectX9̃wvQƂĂ

	@param Stage	[in] ݒ肷Xe[W
	@param State	[in] ݒ肷Xe[g^Cv
	@param Param	[in] p[^
*/
//=============================================================================
void Luna3D::SetSamplerState( Uint32 Stage, D3DSAMPLERSTATETYPE State, Uint32 Param )
{
	if ( (0 <= Stage) && (Stage < TEXTURE_STAGE_MAX) )
	{
		if ( m_SamplerState[Stage][State] != Param )
		{
			m_SamplerState[Stage][State] = Param;
			m_pDevice->SetSamplerState( Stage, State, Param );
		}
	}
}

//=============================================================================
/**
	At@ufBÕ^Cvݒ肵܂

	@param BlendType		[in] ݒ肷uh^Cv

*/
//=============================================================================
void Luna3D::SetBlendingType( eBlendType BlendType )
{
	switch ( BlendType )
	{
	case BLEND_NONE:
		Luna3D::SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_ONE );
		Luna3D::SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ZERO );
		break;

	case BLEND_NORMAL:
		Luna3D::SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
		Luna3D::SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
		break;

	case BLEND_ADD:
		Luna3D::SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
		Luna3D::SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
		break;

	case BLEND_ADD_NOALPHA:
		Luna3D::SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_ONE );
		Luna3D::SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
		break;

	case BLEND_MUL:
		Luna3D::SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_ZERO );
		Luna3D::SetRenderState( D3DRS_DESTBLEND, D3DBLEND_SRCCOLOR );
		break;

	case BLEND_REVERSE:
		Luna3D::SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_INVDESTCOLOR );
		Luna3D::SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ZERO );
		break;
	}
}

//=============================================================================
/**
	oCjAtB^̂nm^nee܂

	@param Flag		[in] oCjAtB^nmɂȂ true / neeɂȂ false

*/
//=============================================================================
void Luna3D::SetBilinearEnable( Bool Flag )
{
	if ( Flag )
	{
		LunaTexture::SetOffsetUV( 0.5f );
		for ( Sint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
		{
			if ( m_DeviceInfo.MaxMaxAnisotropy > 0 )
			{
				Luna3D::SetSamplerState( i, D3DSAMP_MAGFILTER, D3DTEXF_ANISOTROPIC );
				Luna3D::SetSamplerState( i, D3DSAMP_MINFILTER, D3DTEXF_ANISOTROPIC );
				Luna3D::SetSamplerState( i, D3DSAMP_MIPFILTER, D3DTEXF_ANISOTROPIC );
				Luna3D::SetSamplerState( i, D3DSAMP_MAXANISOTROPY, m_DeviceInfo.MaxMaxAnisotropy );
			}
			else
			{
				Luna3D::SetSamplerState( i, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
				Luna3D::SetSamplerState( i, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
				Luna3D::SetSamplerState( i, D3DSAMP_MIPFILTER, D3DTEXF_LINEAR );
			}
		}
	}
	else
	{
		LunaTexture::SetOffsetUV( 0.0f );
		for ( Sint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
		{
			Luna3D::SetSamplerState( i, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
			Luna3D::SetSamplerState( i, D3DSAMP_MINFILTER, D3DTEXF_POINT );
			Luna3D::SetSamplerState( i, D3DSAMP_MIPFILTER, D3DTEXF_POINT );
		}
	}
}

//=============================================================================
/**
	J[L[̂nm^nee܂

	@param Flag		[in] J[L[nmɂȂ true / neeɂȂ false

*/
//=============================================================================
void Luna3D::SetColorkeyEnable( Bool Flag )
{
	if ( Flag )
	{
		Luna3D::SetRenderState( D3DRS_ALPHABLENDENABLE, true );
		Luna3D::SetRenderState( D3DRS_ALPHATESTENABLE, true );
		Luna3D::SetRenderState( D3DRS_ALPHAFUNC, D3DCMP_GREATER );
		Luna3D::SetRenderState( D3DRS_ALPHAREF, 8 );
	}
	else
	{
		Luna3D::SetRenderState( D3DRS_ALPHABLENDENABLE, true );
		Luna3D::SetRenderState( D3DRS_ALPHATESTENABLE, false );
	}
}

//=============================================================================
/**
	J[L[̂nm^nee܂

	@param Flag		[in] J[L[nmɂȂ true / neeɂȂ false

*/
//=============================================================================
void Luna3D::SetZBufferEnable( Bool Flag )
{
	if ( Flag )
	{
		Luna3D::SetRenderState( D3DRS_ZENABLE, D3DZB_TRUE );
	}
	else
	{
		Luna3D::SetRenderState( D3DRS_ZENABLE, D3DZB_FALSE );
	}
}

//=============================================================================
/**
	J[L[̂nm^nee܂

	@param Flag		[in] J[L[nmɂȂ true / neeɂȂ false

*/
//=============================================================================
void Luna3D::SetZWriteEnable( Bool Flag )
{
	if ( Flag )
	{
		Luna3D::SetRenderState( D3DRS_ZWRITEENABLE, true );
	}
	else
	{
		Luna3D::SetRenderState( D3DRS_ZWRITEENABLE, false );
	}
}

//=============================================================================
/**
	J[L[̂nm^nee܂

	@param Flag		[in] J[L[nmɂȂ true / neeɂȂ false

*/
//=============================================================================
void Luna3D::SetWireFrameEnable( Bool Flag )
{
	if ( Flag )
	{
		Luna3D::SetRenderState( D3DRS_FILLMODE, D3DFILL_WIREFRAME );
		Luna3D::SetRenderState( D3DRS_SHADEMODE, D3DSHADE_GOURAUD );
	}
	else
	{
		Luna3D::SetRenderState( D3DRS_FILLMODE, D3DFILL_SOLID );
		Luna3D::SetRenderState( D3DRS_SHADEMODE, D3DSHADE_GOURAUD );
	}
}

//=============================================================================
/**
	tHOpf[^ݒ

	@param fNear	[in] tHOJn_
	@param fFar		[in] tHOI_
	@param Color	[in] tHOF

*/
//=============================================================================
void Luna3D::SetFogParameter( Float fNear, Float fFar, D3DCOLOR Color )
{
	Float start_z = 0.0f;
	Float end_z   = 1.0f;

	Luna3D::SetRenderState( D3DRS_FOGVERTEXMODE, D3DFOG_LINEAR );
	Luna3D::SetRenderState( D3DRS_FOGCOLOR, Color & 0x00FFFFFF );
	Luna3D::SetRenderState( D3DRS_FOGSTART, *((Uint32 *)(&start_z)) );
	Luna3D::SetRenderState( D3DRS_FOGEND,   *((Uint32 *)(&end_z)) );

	m_FogNear  = fNear;
	m_FogFar   = fFar;
	m_FogColor = Color;
}

//=============================================================================
/**
	tHOpf[^擾

	@param pfNear	[in] tHOJn_i[
	@param pfFar	[in] tHOI_i[
	@param pColor	[in] tHOFi[

*/
//=============================================================================
void Luna3D::GetFogParameter( Float *pfNear, Float *pfFar, D3DCOLOR *pColor )
{
	if ( pfNear != NULL ) *pfNear = m_FogNear;
	if ( pfFar  != NULL ) *pfFar  = m_FogFar;
	if ( pColor != NULL ) *pColor = m_FogColor;
}

//=============================================================================
/**
	eobt@eNA܂B

	@param ClearFlags	[in] NAtO<BR>
								D3DCLEAR_TARGET		_O ^[QbgNAāAColor p[^̐Fɂ<BR>
								D3DCLEAR_ZBUFFER	[xobt@NAāADepth p[^̒lɂ<BR>
								D3DCLEAR_STENCIL	XeV obt@NAāAStencil p[^̒lɂ<BR>
	@param Color		[in] D3DCLEAR_TARGET w莞̓hԂF
	@param Depth		[in] D3DCLEAR_ZBUFFER w莞̐[xl
	@param Stencil		[in] D3DCLEAR_STENCIL w莞̃XeVl
	@param pDst			[in] Kp`AhX

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::Clear( Uint32 ClearFlags, D3DCOLOR Color, Float Depth, Uint32 Stencil, RECT *pDst )
{
	return SUCCEEDED( m_pDevice->Clear( (pDst==NULL)?(0):(1), (D3DRECT*)pDst, ClearFlags, Color, Depth, Stencil ) );
}

//=============================================================================
/**
	ʂ̓hԂ܂

	@param pDst		[in] hԂ]`̃|C^
	@param Color	[in] hԂF
*/
//=============================================================================
void Luna3D::ColorFill( RECT *pDst, D3DCOLOR Color )
{
	m_pDevice->Clear( (pDst==NULL)?(0):(1), (D3DRECT*)pDst, D3DCLEAR_TARGET, Color, 1, 0 );
}

//=============================================================================
/**
	RcV[̊JnfoCXɒʒm܂B

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::BeginScene( void )
{
	HRESULT hr = D3D_OK;

	if ( m_SceneCount == 0 )
	{
		hr = m_pDevice->BeginScene();
	}

	m_SceneCount++;

	return SUCCEEDED( hr );
}

//=============================================================================
/**
	RcV[̏IfoCXɒʒm܂B

*/
//=============================================================================
void Luna3D::EndScene( void )
{
	m_SceneCount--;

	if ( m_SceneCount == 0 )
	{
		m_pDevice->EndScene();
	}
}

//=============================================================================
/**
	|SVUO邽߂̗̈ݒ肵܂

	@param IsUse		[in] gpȂ true / gpȂȂ false
	@param pRect		[in] VUO`̃|C^
*/
//=============================================================================
void Luna3D::SetScissoring( Bool IsUse, RECT *pRect )
{
	//------------------------------------------------
	// zʂʂ
	//------------------------------------------------
	if ( IsUse )
	{
		pRect->left   = toI(Luna::Virtual2RealX( toF(pRect->left)   ) - 0.5f);
		pRect->right  = toI(Luna::Virtual2RealX( toF(pRect->right)  ) - 0.5f);
		pRect->top    = toI(Luna::Virtual2RealY( toF(pRect->top)    ) - 0.5f);
		pRect->bottom = toI(Luna::Virtual2RealY( toF(pRect->bottom) ) - 0.5f);
	}

	//------------------------------------------------
	// eNXɓ`B
	//------------------------------------------------
	LunaPrimitive::SetScissoring( IsUse, pRect );
	LunaSprite::SetScissoring( IsUse, pRect );
	LunaLine::SetScissoring( IsUse, pRect );
	LunaPoint::SetScissoring( IsUse, pRect );
}

//=============================================================================
/**
	Qcv~eBu֘A̓ϊ`揈̐ݒ܂

	@param IsUse		[in] gpȂ true / gpȂȂ false
	@param LookX		[in] _wW
	@param LookY		[in] _wW
	@param Scale		[in] p[X̂
*/
//=============================================================================
void Luna3D::SetPerspective( Bool IsUse, Float LookX, Float LookY, Float Scale )
{
	LunaPrimitive::SetPerspective( IsUse, LookX, LookY, Scale );
	LunaSprite::SetPerspective( IsUse, LookX, LookY, Scale );
	LunaLine::SetPerspective( IsUse, LookX, LookY, Scale );
	LunaPoint::SetPerspective( IsUse, LookX, LookY, Scale );
}

//=============================================================================
/*
	Qcv~eBu֘Ågk`揈̐ݒ܂

	@param IsUse		[in] gpȂ true / gpȂȂ false
	@param CenterX		[in] SwW
	@param CenterY		[in] SxW
	@param Zoom			[in] gk
*/
//=============================================================================
void Luna3D::SetZoom( Bool IsUse, Float CenterX, Float CenterY, Float Zoom )
{
	LunaPrimitive::SetZoom( IsUse, CenterX, CenterY, Zoom );
	LunaSprite::SetZoom( IsUse, CenterX, CenterY, Zoom );
	LunaLine::SetZoom( IsUse, CenterX, CenterY, Zoom );
	LunaPoint::SetZoom( IsUse, CenterX, CenterY, Zoom );
}

//=============================================================================
/**
	obNobt@̓etgobt@ɓ]܂B

	@param hWnd		[in] ]EChEnh
*/
//=============================================================================
void Luna3D::Refresh( HWND hWnd )
{
	HRESULT hr;
	//------------------------------------------------------------------
	// ʍXV
	//------------------------------------------------------------------
#ifdef __TOOL_MODE__
	if ( hWnd == NULL )
	{
		hr = m_pDevice->Present( NULL, NULL, NULL, NULL );
	}
	else
	{
		RECT Rect;
		::GetClientRect( hWnd, &Rect );
		hr = m_pDevice->Present( &Rect, &Rect, hWnd, NULL );
	}
#else
	hr = m_pDevice->Present( NULL, NULL, hWnd, NULL );
#endif
	switch ( hr )
	{
	case D3DERR_DRIVERINTERNALERROR:
#ifndef __TOOL_MODE__
		Luna::Exit();
#else
		::SendMessage( ::GetActiveWindow(), WM_CLOSE, 0, 0 );
#endif
		break;
	case D3DERR_DEVICELOST:
		switch ( m_pDevice->TestCooperativeLevel() )
		{
		case D3DERR_DEVICELOST:
			::SleepEx( 10, true );
			break;
		case D3DERR_DEVICENOTRESET:
			Luna3D::ResetDevice( false );
			break;
		}
		break;
	}
}

//=============================================================================
/**
	eNX`foCXɐݒ肵܂

	@param Stage	[in] eNX`Xe[W
	@param lTex		[in] eNX`nh

*/
//=============================================================================
void Luna3D::SetTexture( Uint32 Stage, LTEXTURE lTex )
{
	if ( (0 <= Stage) && (Stage < TEXTURE_STAGE_MAX) )
	{
		if ( lTex == NULL )
		{
			m_pDevice->SetTexture( Stage, NULL );
		}
		else
		{
			IDirect3DTexture9 *pTex;
			((CTexture*)lTex)->GetInstance( &pTex );
			m_pDevice->SetTexture( Stage, pTex );
			SAFE_RELEASE( pTex );
		}
	}
}

//=============================================================================
/**
	T[tFCXp̃tH[}bg̎擾s܂B

	@param Format	[in] T[tFCXtH[}bg
	@param OrgFmt	[in] IWĩt@CtH[}bg

	@return		ۂ̃T[tFCXɓKptH[}bg
*/
//=============================================================================
D3DFORMAT Luna3D::GetFormat( eSurfaceFormat Format, D3DFORMAT OrgFmt )
{
	Bool IsWindow;
	D3DFORMAT ScreenFormat;

	//------------------------------------------------------------
	// EBhE擾
	//------------------------------------------------------------
	Luna::GetScreenData( NULL, NULL, &IsWindow );
	ScreenFormat = IsWindow ? m_WindowMode.Format : m_FullScreenMode[m_IsFullColor ? 1 : 0].Format;

	//------------------------------------------------------------
	// tH[}bg񌟍
	//------------------------------------------------------------
	switch ( Format )
	{
		// t@C
	case FORMAT_FROM_FILE:
		return OrgFmt;

		// 16Bit[xobt@
	case FORMAT_DEPTH16:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_D16_LOCKABLE, D3DFMT_D16, D3DFMT_D15S1, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.DepthCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.DepthFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// 32Bit[xobt@
	case FORMAT_DEPTH32:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_D32, D3DFMT_D24S8, D3DFMT_D24X8, D3DFMT_D24X4S4, D3DFMT_D24FS8, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.DepthCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.DepthFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// XeV[xobt@
	case FORMAT_DEPTHSTENCIL:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_D24S8, D3DFMT_D24X4S4, D3DFMT_D24FS8, D3DFMT_D15S1, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.DepthCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.DepthFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// obNobt@[ɏ
	case FORMAT_BACKBUFFER:
		{
			return ScreenFormat;
		}
		break;

		// 16Bit_O^[Qbg
	case FORMAT_TARGET16:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_A4R4G4B4, D3DFMT_A1R5G5B5, D3DFMT_X1R5G5B5, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TargetCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TargetFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// 32Bit_O^[Qbg
	case FORMAT_TARGET32:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_A8R8G8B8, D3DFMT_X8R8G8B8, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TargetCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TargetFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// __O^[Qbg
	case FORMAT_TARGETFloat:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_A32B32G32R32F, D3DFMT_A16B16G16R16F, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TargetCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TargetFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// At@peNX`
	case FORMAT_ALPHAONLY:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_A8, D3DFMT_A8R3G3B2, D3DFMT_A8R8G8B8, D3DFMT_A4R4G4B4, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TextureCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TextureFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// 32BiteNX`tH[}bgɏ
	case FORMAT_TEXTURE32:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_A8R8G8B8, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TextureCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TextureFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// 16BiteNX`tH[}bgɏ
	case FORMAT_TEXTURE16:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_A4R4G4B4, D3DFMT_A1R5G5B5, D3DFMT_A8R3G3B2, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TextureCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TextureFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// DXT1ktH[}bgeNX`
	case FORMAT_DXT1:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_DXT1, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TextureCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TextureFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// DXT3ktH[}bgeNX`
	case FORMAT_DXT3:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_DXT3, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TextureCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TextureFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// DXT5ktH[}bgeNX`
	case FORMAT_DXT5:
		{
			D3DFORMAT FmtTbl[] = {
				D3DFMT_DXT5, D3DFMT_UNKNOWN,
			};

			for ( Sint32 i = 0; FmtTbl[i] != D3DFMT_UNKNOWN; i++ )
			{
				for ( Sint32 j = 0; j < m_AdapterData.TextureCount; j++ )
				{
					if ( FmtTbl[i] == m_AdapterData.TextureFormats[j] )
					{
						return FmtTbl[i];
					}
				}
			}
		}
		break;

		// [U[`2DeNX`
	case FORMAT_TEXTURE_2D:
		{
			for ( Uint32 i = 0; i < m_SurfaceFormatCount[0]; i++ )
			{
				D3DFORMAT Fmt = GetFormat( m_SurfaceFormatTbl[0][i], D3DFMT_UNKNOWN );
				if ( Fmt != D3DFMT_UNKNOWN )
				{
					return Fmt;
				}
			}
		}
		break;

		// [U[`3DeNX`
	case FORMAT_TEXTURE_3D:
		{
			for ( Uint32 i = 0; i < m_SurfaceFormatCount[1]; i++ )
			{
				D3DFORMAT Fmt = GetFormat( m_SurfaceFormatTbl[1][i], D3DFMT_UNKNOWN );
				if ( Fmt != D3DFMT_UNKNOWN )
				{
					return Fmt;
				}
			}
		}
		break;
	}

	return D3DFMT_UNKNOWN;
}

//=============================================================================
/**
	2DpT[tFCXtH[}bge[uݒ肵܂

	@param FmtTbl	[in] T[tFCXtH[}bge[u
	@param Count	[in] T[tFCXtH[}bge[u
*/
//=============================================================================
void Luna3D::SetSurfaceFormatTblFor2D( eSurfaceFormat FmtTbl[], Uint32 Count )
{
	MemoryCopy( m_SurfaceFormatTbl[0], FmtTbl, sizeof(eSurfaceFormat) * Count );
	m_SurfaceFormatCount[0] = Count;
}

//=============================================================================
/**
	3DpT[tFCXtH[}bge[uݒ肵܂

	@param FmtTbl	[in] T[tFCXtH[}bge[u
	@param Count	[in] T[tFCXtH[}bge[u
*/
//=============================================================================
void Luna3D::SetSurfaceFormatTblFor3D( eSurfaceFormat FmtTbl[], Uint32 Count )
{
	MemoryCopy( m_SurfaceFormatTbl[1], FmtTbl, sizeof(eSurfaceFormat) * Count );
	m_SurfaceFormatCount[1] = Count;
}

//=============================================================================
/**
	[xobt@ɎgpT[tFCXݒ肵܂

	@param lSurf	[in] T[tFCXnh

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::SetDepthStencilSurface( LSURFACE lSurf )
{
	if ( lSurf == NULL )
	{
		m_lSurfDepthStencil = NULL;
		Luna3D::GetDevice()->SetDepthStencilSurface( NULL );

		return true;
	}
	else
	{
		m_lSurfDepthStencil = lSurf;
		((CSurface*)lSurf)->SetDepthStencil();

		return true;
	}
}

//=============================================================================
/**
	_OɎgpJݒ肵܂

	@param lCam		[in] Jnh

*/
//=============================================================================
void Luna3D::SetCamera( LCAMERA lCam )
{
	if ( lCam == INVALID_CAMERA ) return;

	m_lCamera = lCam;
	LunaCamera::SetDevice( m_lCamera );
}

//=============================================================================
/**
	_O^[QbgɎgT[tFCXݒ肵܂

	@param lSurf		[in] T[tFCXnh

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::SetRenderTargetSurface( LSURFACE lSurf )
{
	if ( lSurf != NULL )
	{
		m_lTexTarget = NULL;
		m_lSurfTarget = lSurf;

		if ( ((CSurface*)m_lSurfTarget)->SetRenderTarget() )
		{
			ResetDepthStencil();
		
			return true;
		}
	}
	else
	{
		m_lTexTarget = NULL;
		m_lSurfTarget = NULL;

		RECT View = { 0, 0, 0, 0 };
		Luna::GetScreenData( &View.right, &View.bottom, NULL );

		if ( ResetRenderTarget() )
		{
			SetViewport( &View );
	
			ResetDepthStencil();

			return true;
		}
	}

	return false;
}

//=============================================================================
/**
	_O^[QbgɎgeNX`ݒ肵܂

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::ResetRenderTarget( void )
{
	if SUCCEEDED( m_pDevice->SetRenderTarget( 0, m_pRenderTarget ) )
	{
		ResetDepthStencil();

		return true;
	}

	return false;
}

//=============================================================================
/**
	_O^[QbgɎgeNX`ݒ肵܂

	@param pDstRect		[in] ]`(NULLőS
	@param lSurf		[in] ]T[tFCX
	@param pSrcRect		[in] ]`(NULLőS

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::CopyToRenderTarget( RECT *pDstRect, LSURFACE lSurf, RECT *pSrcRect )
{
	CSurface *pSrc = (CSurface*)lSurf;
	IDirect3DSurface9 *pSrcSurf;
	HRESULT hr;

	pSrc->GetInstance( &pSrcSurf );

	hr = GetDevice()->StretchRect(
						pSrcSurf,
						pSrcRect,
						m_pRenderTarget,
						pDstRect,
						D3DTEXF_NONE );

	pSrcSurf->Release();

	return SUCCEEDED( hr );
}


//=============================================================================
/**
	_O^[QbgɎgeNX`ݒ肵܂

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::ResetDepthStencil( void )
{
	if ( m_lSurfDepthStencil != NULL )
	{
		if ( ((CSurface*)m_lSurfDepthStencil)->SetDepthStencil() )
		{
			SetRenderState( D3DRS_ZENABLE, true );
			SetRenderState( D3DRS_ZWRITEENABLE, true );

			return true;
		}

		SetRenderState( D3DRS_ZENABLE, false );
		SetRenderState( D3DRS_ZWRITEENABLE, false );

		return false;
	}

	SetRenderState( D3DRS_ZENABLE, false );
	SetRenderState( D3DRS_ZWRITEENABLE, false );

	return true;
}

//=============================================================================
/**
	_O^[QbgɎgeNX`ݒ肵܂

	@param lTex		[in] eNX`nh

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::SetRenderTargetTexture( LTEXTURE lTex )
{
	if ( lTex != NULL )
	{
		m_lTexTarget = lTex;
		m_lSurfTarget = NULL;

		if ( ((CTexture*)m_lTexTarget)->SetRenderTarget() )
		{
			RECT View = { 0, 0, ((CTexture*)m_lTexTarget)->GetWidth(), ((CTexture*)m_lTexTarget)->GetHeight() };
			SetViewport( &View );

			ResetDepthStencil();

			return true;
		}
	}
	else
	{
		m_lTexTarget = NULL;
		m_lSurfTarget = NULL;

		RECT View = { 0, 0, 0, 0 };
		Luna::GetScreenData( &View.right, &View.bottom, NULL );

		if ( ResetRenderTarget() )
		{
			SetViewport( &View );
			ResetDepthStencil();

			return true;
		}
	}

	return false;
}

//=============================================================================
/**
	Cĝnm^neeݒ肵܂

	@param No			[in] Cgԍ
	@param IsActive		[in] true gp / false gp
*/
//=============================================================================
void Luna3D::SetLight( Sint32 No, Bool IsActive )
{
	LunaLight::SetDevice( No, IsActive );
}

//=============================================================================
/**
	cboR̃tHg`Jn܂

	@param pFontFace	[in] tHg
	@param FontSize		[in] tHgTCY

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::FontBegin( const char *pFontFace, Sint32 FontSize )
{
	HRESULT hr;

	//----------------------------------------------
	// cb擾
	//----------------------------------------------
	hr = m_pRenderTarget->GetDC( &m_hDC );
	if FAILED( hr )
	{
		return false;
	}

	//----------------------------------------------
	// tHg
	//----------------------------------------------
	m_hFont = ::CreateFont(
						FontSize,					// tHg
						0,							// 
						0,							// eLXg̊px	
						0,							// x[XCƂƂ̊px
						0,							// tHg̏dij
						false,						// C^bN
						false,						// A_[C
						false,						// ł
						SHIFTJIS_CHARSET,			// Zbg
						OUT_TT_PRECIS,				// o͐x
						CLIP_DEFAULT_PRECIS,		// NbsOx
						PROOF_QUALITY,				// o͕i
						FIXED_PITCH | FF_MODERN,	// sb`ƃt@~[
						pFontFace );				// ̖

	// tHgݒ
	m_hOldFont = (HFONT)::SelectObject( m_hDC, m_hFont );

	return true;
}

//=============================================================================
/**
	cboR̃tHg`܂

	@param Px			[] `wʒu
	@param Py			[] `xʒu
	@param FontColor	[] tHgJ[
	@param BackColor	[] wiJ[
	@param pStr,...		[] `敶iprintf()Ɠl̏j
*/
//=============================================================================
void Luna3D::FontDraw( Sint32 Px, Sint32 Py, COLORREF FontColor, COLORREF BackColor, const char *pStr,... )
{
	char Temp[1024] = "";
	vsprintf( Temp, pStr, (char*)(&pStr + 1) );

	// q[F
	::SetBkColor( m_hDC, BackColor );
	::SetBkMode( m_hDC, OPAQUE );

	// tHgF
	::SetTextColor( m_hDC, FontColor );

	// tHg`
	::TextOut( m_hDC, Px, Py, Temp, (Sint32)strlen(Temp) );
}

//=============================================================================
/**
	cboR̃tHg`I܂

*/
//=============================================================================
void Luna3D::FontEnd( void )
{
	::SelectObject( m_hDC, m_hOldFont );
	::DeleteObject( m_hFont );

	m_pRenderTarget->ReleaseDC( m_hDC );
}

//=============================================================================
/**
	tB[g̃`FbNJn

*/
//=============================================================================
void Luna3D::FillRateCheckStart( void )
{
	if ( m_pQuery[1] != NULL )
	{
		if ( !m_IsCheckingFillRate )
		{
			m_IsCheckingFillRate = true;
			m_pQuery[1]->Issue( D3DISSUE_BEGIN );
		}
	}
}

//=============================================================================
/**
	tB[g̃`FbNI

	@return tBsNZ
*/
//=============================================================================
Uint32 Luna3D::FillRateCheckEnd( void )
{
	if ( m_pQuery[1] != NULL )
	{
		if ( m_IsCheckingFillRate )
		{
			m_IsCheckingFillRate = false;
			m_pQuery[1]->Issue( D3DISSUE_END );

			Uint32 Data = 0;
			HRESULT hr = m_pQuery[1]->GetData( &Data, sizeof(Uint32), D3DGETDATA_FLUSH );
			if FAILED( hr )
			{
				LunaDebug::OutputString( Luna3D::GetError( hr ) );
				return 0xFFFFFFFF;
			}
			return Data;
		}
	}

	return 0;
}

//=============================================================================
/**
	_ȌI҂

*/
//=============================================================================
Bool Luna3D::BlockForEndRendering( void )
{
	if ( m_pQuery[0] != NULL )
	{
		m_pQuery[0]->Issue( D3DISSUE_END );

		BOOL Data = false;
		return (S_OK == m_pQuery[0]->GetData( &Data, sizeof(BOOL), D3DGETDATA_FLUSH ));
	}
	return false;
}

//=============================================================================
/**
	obNobt@̃bN܂

	@param ppBits		[out] obt@̃sNZf[^̐擪AhXi[
	@param pPitch		[out] T[tFCX̃sb`i[AhX
	@param pFormat		[out] T[tFCX̃tH[}bgi[AhX
	@param pWidth		[out] T[tFCX̉i[AhX
	@param pHeight		[out] T[tFCX̏ci[AhX

	@retval true		
	@retval false		s
*/
//=============================================================================
Bool Luna3D::LockBackBuffer( void **ppBits, Sint32 *pPitch, D3DFORMAT *pFormat, Sint32 *pWidth, Sint32 *pHeight )
{
	if ( !m_IsLocked )
	{
		HRESULT hr;
		IDirect3DSurface9 *pBackBuffer = NULL;

		// obNobt@擾
		hr = m_pDevice->GetBackBuffer( 0, 0, D3DBACKBUFFER_TYPE_MONO, &pBackBuffer );
		if SUCCEEDED( hr )
		{
			D3DSURFACE_DESC Desc;
			pBackBuffer->GetDesc( &Desc );
			*pFormat = Desc.Format;
			*pWidth = Desc.Width;
			*pHeight = Desc.Height;

			D3DLOCKED_RECT rect;
			HRESULT hr = pBackBuffer->LockRect( &rect, NULL, 0 );
			*pPitch = rect.Pitch;
			*ppBits = rect.pBits;

			m_IsLocked = SUCCEEDED( hr );

			SAFE_RELEASE( pBackBuffer );
		}
	}

	return m_IsLocked;
}

//=============================================================================
/**
	obNobt@̃bN܂

*/
//=============================================================================
void Luna3D::UnlockBackBuffer( void )
{
	if ( m_IsLocked )
	{
		HRESULT hr;
		IDirect3DSurface9 *pBackBuffer = NULL;

		// obNobt@擾
		hr = m_pDevice->GetBackBuffer( 0, 0, D3DBACKBUFFER_TYPE_MONO, &pBackBuffer );
		if SUCCEEDED( hr )
		{
			pBackBuffer->UnlockRect();
			SAFE_RELEASE( pBackBuffer );
			m_IsLocked = false;
		}
	}
}

//=============================================================================
/**
	[hWXN[Ԃւ̕ϊ܂

	@param pWorldPos	[in] [hԂ̍W
	@param pScreenPos	[out] XN[̍W
*/
//=============================================================================
void Luna3D::WorldToScreen( CVector3D *pWorldPos, CVector3D *pScreenPos )
{
	CMatrix mCamera;
	CVector3D vWorld;

	//----------------------------------------------
	// Js擾
	//----------------------------------------------
	LunaCamera::GetMatrixDirect( NULL, NULL, &mCamera );

	//----------------------------------------------
	// JԂɕϊ
	//----------------------------------------------
	vWorld.TransformProjection( pWorldPos, &mCamera );

	//----------------------------------------------
	// vWFNVԂɕϊ
	//----------------------------------------------
	Float w = toF(m_Viewport.Width  / 2);
	Float h = toF(m_Viewport.Height / 2);
	Float x = toF(m_Viewport.X + w);
	Float y = toF(m_Viewport.Y + h);

	pScreenPos->x = x + (+vWorld.x * w);
	pScreenPos->y = y + (-vWorld.y * h);
}

//=============================================================================
/**
	XN[W烏[hԂւ̕ϊ܂

	@param pWorldPos	[out] [hԂ̍W
	@param pScreenPos	[in] XN[̍W
*/
//=============================================================================
void Luna3D::ScreenToWorld( CVector3D *pWorldPos, CVector3D *pScreenPos )
{
	CMatrix mCameraInv;

	//----------------------------------------------
	// Js擾
	//----------------------------------------------
	LunaCamera::GetMatrixDirect( NULL, NULL, NULL, &mCameraInv );

	//----------------------------------------------
	// vWFNVԂɕϊ
	//----------------------------------------------
	Float w = toF(m_Viewport.Width  / 2);
	Float h = toF(m_Viewport.Height / 2);
	Float x = toF(m_Viewport.X + w);
	Float y = toF(m_Viewport.Y + h);
	pWorldPos->x = +toF(pScreenPos->x - x) / w;
	pWorldPos->y = -toF(pScreenPos->y - y) / h;
	pWorldPos->z = pScreenPos->z;

	//----------------------------------------------
	// JԂɕϊ
	//----------------------------------------------
	pWorldPos->TransformProjection( &mCameraInv );
}

//=============================================================================
/**
	XN[Wr[Ԃւ̕ϊ܂

	@param pViewPos		[out] r[Ԃ̍W
	@param pScreenPos	[in] XN[̍W
*/
//=============================================================================
void Luna3D::ScreenToView( CVector3D *pViewPos, CVector3D *pScreenPos )
{
	CMatrix mCamera;

	//----------------------------------------------
	// Js擾
	//----------------------------------------------
	LunaCamera::GetMatrixDirect( &mCamera, NULL, NULL );

	//----------------------------------------------
	// vWFNVԂɕϊ
	//----------------------------------------------
	Float w = toF(m_Viewport.Width  / 2);
	Float h = toF(m_Viewport.Height / 2);
	Float x = toF(m_Viewport.X + w);
	Float y = toF(m_Viewport.Y + h);
	pViewPos->x = +toF(pScreenPos->x - x) / w;
	pViewPos->y = -toF(pScreenPos->y - y) / h;
	pViewPos->z = pScreenPos->z;

	//----------------------------------------------
	// JԂɕϊ
	//----------------------------------------------
	mCamera.Inverse();
	pViewPos->TransformProjection( &mCamera );
}

//=============================================================================
/**
	w`NbsO܂

	@param pDst		[in/out] ]`
	@param pSrc		[in/out] ]`

	@retval true	`\
	@retval false	`sv
*/
//=============================================================================
Bool Luna3D::Clip( RECT *pDst, RECT *pSrc )
{
	// r[|[g
	Sint32 x1 = m_Viewport.X;
	Sint32 y1 = m_Viewport.Y;
	Sint32 x2 = x1 + m_Viewport.Width;
	Sint32 y2 = y1 + m_Viewport.Height;

	// ]`
	Sint32 dx1 = pDst->left;
	Sint32 dy1 = pDst->top;
	Sint32 dx2 = pDst->right;
	Sint32 dy2 = pDst->bottom;

	// ]`
	Sint32 sx1 = pSrc->left;
	Sint32 sy1 = pSrc->top;
	Sint32 sx2 = pSrc->right;
	Sint32 sy2 = pSrc->bottom;

	// TCY䗦
	Float fx = toF(sx2 - sx1) / toF(dx2 - dx1);
	Float fy = toF(sy2 - sy1) / toF(dy2 - dy1);

	// `FbN
	if ( dx1 < x1 )
	{
		sx1 = sx1 + toI(toF(x1 - dx1) * fx);
		dx1 = x1;
	}
	// `FbN
	if ( dy1 < y1 )
	{
		sy1 = sy1 + toI(toF(y1 - dy1) * fy);
		dy1 = y1;
	}
	// E`FbN
	if ( dx2 > x2 )
	{
		sx2 = sx2 - toI(toF(dx2 - x2) * fx);
		dx2 = x2;
	}
	// `FbN
	if ( dy2 > y2 )
	{
		sy2 = sy2 - toI(toF(dy2 - y2) * fy);
		dy2 = y2;
	}

	// ]`
	pDst->left		= dx1;
	pDst->top		= dy1;
	pDst->right		= dx2;
	pDst->bottom	= dy2;

	// ]`
	pSrc->left		= sx1;
	pSrc->top		= sy1;
	pSrc->right		= sx2;
	pSrc->bottom	= sy2;

	return ((dx1 < dx2) && (dy1 < dy2));
}

//=============================================================================
/**
	gp\ȐeNX`eʂ擾܂B

	@return		e(MByte)
*/
//=============================================================================
Uint32 Luna3D::GetRestVRAM( void )
{
	return m_pDevice->GetAvailableTextureMem() / 1024 / 1024;
}

//=============================================================================
/**
	D3DFORMAT^̎sNZtH[}bg𕶎ƂĎ擾܂

	@param Format	[in] sNZtH[}bgʗp萔
	@param pStr		[out] i[

	@return		sNZtH[}bg̃|C^
*/
//=============================================================================
char *Luna3D::GetPixelFormat( D3DFORMAT Format, char *pStr )
{
	static char String[MAX_PATH];

	switch ( Format )
	{
	case D3DFMT_UNKNOWN:			strcpy( String, "UNKNOWN" );		break;
	case D3DFMT_R8G8B8:				strcpy( String, "R8G8B8" );		break;
	case D3DFMT_A8R8G8B8:			strcpy( String, "A8R8G8B8" );		break;
	case D3DFMT_X8R8G8B8:			strcpy( String, "X8R8G8B8" );		break;
	case D3DFMT_R5G6B5:				strcpy( String, "R5G6B5" );		break;
	case D3DFMT_X1R5G5B5:			strcpy( String, "X1R5G5B5" );		break;
	case D3DFMT_A1R5G5B5:			strcpy( String, "A1R5G5B5" );		break;
	case D3DFMT_A4R4G4B4:			strcpy( String, "A4R4G4B4" );		break;
	case D3DFMT_R3G3B2:				strcpy( String, "R3G3B2" );		break;
	case D3DFMT_A8:					strcpy( String, "A8" );			break;
	case D3DFMT_A8R3G3B2:			strcpy( String, "A8R3G3B2" );		break;
	case D3DFMT_X4R4G4B4:			strcpy( String, "X4R4G4B4" );		break;
	case D3DFMT_A2B10G10R10:		strcpy( String, "A2B10G10R10" );	break;
	case D3DFMT_A8B8G8R8:			strcpy( String, "A8B8G8R8" );		break;
	case D3DFMT_X8B8G8R8:			strcpy( String, "X8B8G8R8" );		break;
	case D3DFMT_G16R16:				strcpy( String, "G16R16" );		break;
	case D3DFMT_A2R10G10B10:		strcpy( String, "A2R10G10B10" );	break;
	case D3DFMT_A16B16G16R16:		strcpy( String, "A16B16G16R16" );	break;
	case D3DFMT_A8P8:				strcpy( String, "A8P8" );			break;
	case D3DFMT_P8:					strcpy( String, "P8" );			break;
	case D3DFMT_L8:					strcpy( String, "L8" );			break;
	case D3DFMT_L16:				strcpy( String, "L16" );			break;
	case D3DFMT_A8L8:				strcpy( String, "A8L8" );			break;
	case D3DFMT_A4L4:				strcpy( String, "A4L4" );			break;
	case D3DFMT_V8U8:				strcpy( String, "V8U8" );			break;
	case D3DFMT_Q8W8V8U8:			strcpy( String, "Q8W8V8U8" );		break;
	case D3DFMT_V16U16:				strcpy( String, "V16U16" );		break;
	case D3DFMT_Q16W16V16U16:		strcpy( String, "Q16W16V16U16" );	break;
	case D3DFMT_CxV8U8:				strcpy( String, "CxV8U8" );		break;
	case D3DFMT_L6V5U5:				strcpy( String, "L6V5U5" );		break;
	case D3DFMT_X8L8V8U8:			strcpy( String, "X8L8V8U8" );		break;
	case D3DFMT_A2W10V10U10:		strcpy( String, "A2W10V10U10" );	break;
	case D3DFMT_G8R8_G8B8:			strcpy( String, "G8R8_G8B8" );		break;
	case D3DFMT_R8G8_B8G8:			strcpy( String, "R8G8_B8G8" );		break;
	case D3DFMT_DXT1:				strcpy( String, "DXT1" );			break;
	case D3DFMT_DXT2:				strcpy( String, "DXT2" );			break;
	case D3DFMT_DXT3:				strcpy( String, "DXT3" );			break;
	case D3DFMT_DXT4:				strcpy( String, "DXT4" );			break;
	case D3DFMT_DXT5:				strcpy( String, "DXT5" );			break;
	case D3DFMT_UYVY:				strcpy( String, "UYVY" );			break;
	case D3DFMT_YUY2:				strcpy( String, "YUY2" );			break;
	case D3DFMT_D16_LOCKABLE:		strcpy( String, "D16_LOCKABLE" );	break;
	case D3DFMT_D32:				strcpy( String, "D32" );			break;
	case D3DFMT_D15S1:				strcpy( String, "D15S1" );			break;
	case D3DFMT_D24S8:				strcpy( String, "D24S8" );			break;
	case D3DFMT_D24X8:				strcpy( String, "D24X8" );			break;
	case D3DFMT_D24X4S4:			strcpy( String, "D24X4S4" );		break;
	case D3DFMT_D32F_LOCKABLE:		strcpy( String, "D32F_LOCKABLE" );	break;
	case D3DFMT_D24FS8:				strcpy( String, "D24FS8" );		break;
	case D3DFMT_D16:				strcpy( String, "D16" );			break;
	case D3DFMT_VERTEXDATA:			strcpy( String, "VERTEXDATA" );	break;
	case D3DFMT_INDEX16:			strcpy( String, "INDEX16" );		break;
	case D3DFMT_INDEX32:			strcpy( String, "INDEX32" );		break;
	case D3DFMT_R16F:				strcpy( String, "R16F" );			break;
	case D3DFMT_G16R16F:			strcpy( String, "G16R16F" );		break;
	case D3DFMT_A16B16G16R16F:		strcpy( String, "A16B16G16R16F" );	break;
	case D3DFMT_R32F:				strcpy( String, "R32F" );			break;
	case D3DFMT_G32R32F:			strcpy( String, "G32R32F" );		break;
	case D3DFMT_A32B32G32R32F:		strcpy( String, "A32B32G32R32F" );	break;
	}

	if ( pStr != NULL ) strcpy( pStr, String );

	return String;
}

//=============================================================================
/**
	HRESULT^̎Direct3D֘ÃG[𕶎ƂĎ擾܂

	@param hr	[in] G[ʗp萔

	@return		G[̃|C^
*/
//=============================================================================
char *Luna3D::GetError( HRESULT hr )
{
	static char String[MAX_PATH] = "";

	switch ( hr )
	{
	case D3D_OK:
		strcpy( String, "G[͔ĂȂB" );
		break;
	case D3DERR_CONFLICTINGRENDERSTATE:
		strcpy( String, "ݐݒ肳Ă郌_O Xe[g͈ꏏɎgpłȂB" );
		break;
	case D3DERR_CONFLICTINGTEXTUREFILTER:
		strcpy( String, "݂̃eNX` tB^͈ꏏɎgpłȂB" );
		break;
	case D3DERR_CONFLICTINGTEXTUREPALETTE:
		strcpy( String, "݂̃eNX`͓ɎgpłȂBʂɃ}`eNX` foCXɂāAɗLɂꂽpbgeNX`œpbgLKvꍇɔB" );
		break;
	case D3DERR_DEVICELOST:
		strcpy( String, "foCXĂāA_ł͕łȂ߁A_O͕s\łB" );
		break;
	case D3DERR_DEVICENOTRESET:
		strcpy( String, "foCX̓ZbgłȂB" );
		break;
	case D3DERR_DRIVERINTERNALERROR:
		strcpy( String, "hCo G[B" );
		break;
	case D3DERR_INVALIDCALL:
		strcpy( String, "\bȟĂяołBƂ΁A\bh̃p[^ɖȒlݒ肳ĂꍇȂǁB" );
		break;
	case D3DERR_INVALIDDEVICE:
		strcpy( String, "vꂽfoCX̎ނLłȂB" );
		break;
	case D3DERR_MOREDATA:
		strcpy( String, "w肳ꂽobt@ TCYɕێłȏ̃f[^݂B" );
		break;
	case D3DERR_NOTAVAILABLE:
		strcpy( String, "̃foCX́AƉꂽeNjbNT|[gĂȂB" );
		break;
	case D3DERR_NOTFOUND:
		strcpy( String, "vꂽڂȂB" );
		break;
	case D3DERR_OUTOFVIDEOMEMORY:
		strcpy( String, "Direct3D ŝɏ\ȃfBXvC ȂB" );
		break;
	case D3DERR_TOOMANYOPERATIONS:
		strcpy( String, "foCXT|[gĂȏ̃eNX` tB^OAAvP[VvĂB" );
		break;
	case D3DERR_UNSUPPORTEDALPHAARG:
		strcpy( String, "At@ `lɑ΂Ďw肳ĂeNX` ufBOAfoCXT|[gĂȂB" );
		break;
	case D3DERR_UNSUPPORTEDALPHAOPERATION:
		strcpy( String, "At@ `lɑ΂Ďw肳ĂeNX` ufBOAfoCXT|[gĂȂB" );
		break;
	case D3DERR_UNSUPPORTEDCOLORARG:
		strcpy( String, "J[lɑ΂Ďw肳ĂeNX` ufBOAfoCXT|[gĂȂB" );
		break;
	case D3DERR_UNSUPPORTEDCOLOROPERATION:
		strcpy( String, "J[lɑ΂Ďw肳ĂeNX` ufBOAfoCXT|[gĂȂB" );
		break;
	case D3DERR_UNSUPPORTEDFACTORVALUE:
		strcpy( String, "foCXw肳ꂽeNX`WlT|[gĂȂB" );
		break;
	case D3DERR_UNSUPPORTEDTEXTUREFILTER:
		strcpy( String, "foCXw肳ꂽeNX` tB^T|[gĂȂB" );
		break;
	case D3DERR_WRONGTEXTUREFORMAT:
		strcpy( String, "eNX` T[tFX̃sNZ tH[}bgLłȂB" );
		break;
	case E_FAIL:
		strcpy( String, "Direct3D TuVXeŌs̃G[B" );
		break;
	case E_INVALIDARG:
		strcpy( String, "ȃp[^߂Ă֐ɓnꂽB" );
		break;
	case E_OUTOFMEMORY:
		strcpy( String, "Direct3D Ăяo邽߂̏\ȃ蓖Ă邱ƂłȂB" );
		break;
	case D3DXERR_CANNOTATTRSORT:
		strcpy( String, "œKeNjbNƂđ̃\[g (D3DXMESHOPT_ATTRSORT) ̓T|[gĂȂB " );
		break;
	case D3DXERR_CANNOTMODIFYINDEXBUFFER:
		strcpy( String, "CfbNX obt@ύXłȂB " );
		break;
	case D3DXERR_INVALIDMESH:
		strcpy( String, "bVłB " );
		break;
	case D3DXERR_SKINNINGNOTSUPPORTED:
		strcpy( String, "XLjO̓T|[gĂȂB " );
		break;
	case D3DXERR_TOOMANYINFLUENCES:
		strcpy( String, "w肳ꂽeB " );
		break;
	case D3DXERR_INVALIDDATA:
		strcpy( String, "f[^łB" );
		break;
	default:
		strcpy( String, "m̃G[B" );
		break;
	}

	return String;
}

//=============================================================================
/**
	ʃ[h̎擾܂

	@param IsFullColor	[in] tJ[ʂǂ

	@return		[h
*/
//=============================================================================
Sint32 Luna3D::GetScreenModeCount( Bool IsFullColor )
{
	Sint32 Count = 0;

	if ( IsFullColor )
	{
		for ( Sint32 i = 0; i < m_AdapterData.ModeCount; i++ )
		{
			if ( m_AdapterData.Mode[i].Format == m_FullScreenMode[1].Format )
			{
				Count++;
			}
		}
	}
	else
	{
		for ( Sint32 i = 0; i < m_AdapterData.ModeCount; i++ )
		{
			if ( m_AdapterData.Mode[i].Format == m_FullScreenMode[0].Format )
			{
				Count++;
			}
		}
	}

	return Count;
}

//=============================================================================
/**
	ʃ[h̎擾܂

	@param IsFullColor	[in] tJ[ʂǂ
	@param No			[in] ʃTCYԍ
	@param pWidth		[out] ʉ
	@param pHeight		[out] ʏc

*/
//=============================================================================
void Luna3D::GetScreenMode( Bool IsFullColor, Sint32 No, Sint32 *pWidth, Sint32 *pHeight )
{
	if ( IsFullColor )
	{
		for ( Sint32 i = 0; i < m_AdapterData.ModeCount; i++ )
		{
			if ( m_AdapterData.Mode[i].Format == m_FullScreenMode[1].Format )
			{
				if ( No-- == 0 )
				{
					*pWidth = m_AdapterData.Mode[i].Width;
					*pHeight = m_AdapterData.Mode[i].Height;
					return;
				}
			}
		}
	}
	else
	{
		for ( Sint32 i = 0; i < m_AdapterData.ModeCount; i++ )
		{
			if ( m_AdapterData.Mode[i].Format == m_FullScreenMode[0].Format )
			{
				if ( No-- == 0 )
				{
					*pWidth = m_AdapterData.Mode[i].Width;
					*pHeight = m_AdapterData.Mode[i].Height;
					return;
				}
			}
		}
	}

	*pWidth = 0;
	*pHeight = 0;
}

//=============================================================================
/**
	_O^[QbgeNX`TCY̎擾܂

    @return		eNX`TCY
*/
//=============================================================================
Sint32 Luna3D::GetRenderTargetTextureSizeCount( void )
{
	Sint32 Count = 0;

	if ( m_DeviceInfo.MaxTextureWidth <  m_DeviceInfo.MaxTextureHeight )
	{
		for ( Uint32 i = 32; i <= m_DeviceInfo.MaxTextureWidth; i <<= 1 ) Count++;
	}
	else
	{
		for ( Uint32 i = 32; i <= m_DeviceInfo.MaxTextureHeight; i <<= 1 ) Count++;
	}

	return Count;
}

//=============================================================================
/**
	_O^[QbgeNX`TCY̎擾܂

	@param No			[in] ʃTCYԍ
	@param pWidth		[out] ʉ
	@param pHeight		[out] ʏc

*/
//=============================================================================
void Luna3D::GetRenderTargetTextureSize( Sint32 No, Sint32 *pWidth, Sint32 *pHeight )
{
	Sint32 Count = 0;

	if ( m_DeviceInfo.MaxTextureWidth <  m_DeviceInfo.MaxTextureHeight )
	{
		for ( Uint32 i = 32; i <= m_DeviceInfo.MaxTextureWidth; i <<= 1 )
		{
			if ( Count++ == No )
			{
				*pWidth = *pHeight = i;
				return;
			}
		}
	}
	else
	{
		for ( Uint32 i = 32; i <= m_DeviceInfo.MaxTextureHeight; i <<= 1 )
		{
			if ( Count++ == No )
			{
				*pWidth = *pHeight = i;
				return;
			}
		}
	}

	*pWidth = *pHeight = 0;
}

//=============================================================================
/**
	A_v^[̎擾܂

	@param pName	[out] 擾̊i[

*/
//=============================================================================
void Luna3D::GetAdapterName( char *pName )
{
	strcpy( pName, m_AdapterName );
}

//=============================================================================
/**
	A_v^[hCo[̎擾܂

	@param pName	[out] 擾̊i[

*/
//=============================================================================
void Luna3D::GetAdapterDriver( char *pName )
{
	strcpy( pName, m_AdapterDriver );
}

//=============================================================================
/**
	A_v^[hCo[o[W̎擾܂

	@param pName	[out] 擾̊i[

*/
//=============================================================================
void Luna3D::GetAdapterVersion( char *pName )
{
	strcpy( pName, m_AdapterVersion );
}

//=============================================================================
/**
	_CAO{bNX[hgp邩ǂ

	@param IsMode	[in] gp邩ۂ

*/
//=============================================================================
void Luna3D::SetDialogMode( Bool IsMode )
{
	if ( m_pDevice != NULL )
	{
		m_pDevice->SetDialogBoxMode( IsMode );
	}
}

//=============================================================================
/**
	ftHg̃f}eAXe[g擾

	@param pState	[in] Xe[g

*/
//=============================================================================
void Luna3D::GetDefaultMateriaState( MATERIALSTATE *pState )
{
	*pState = m_DefaultState;
}

//=============================================================================
/**
	ftHg̃f}eAXe[g擾

	@param pState	[in] Xe[g

*/
//=============================================================================
void Luna3D::SetMateriaRenderState( MATERIALSTATE *pState )
{
	Luna3D::SetBlendingType( pState->BlendType );
	Luna3D::SetBilinearEnable( pState->IsBilinear );
	Luna3D::SetColorkeyEnable( pState->IsColorKey );
	Luna3D::SetZBufferEnable( pState->IsZBuffer );
	Luna3D::SetZWriteEnable( pState->IsZWrite );

	for ( Uint32 i = 0; i < TEXTURE_STAGE_MAX; i++ )
	{
		for ( Uint32 j = 0; j < TextureStateTblCount; j++ )
		{
			Luna3D::SetTextureState( i, TextureStateTbl[j], pState->TextureState[i][TextureStateTbl[j]] );
		}

		for ( Uint32 j = 0; j < SamplerStateTblCount; j++ )
		{
			Luna3D::SetSamplerState( i, SamplerStateTbl[j], pState->SamplerState[i][SamplerStateTbl[j]] );
		}
	}
}

