//=============================================================================
//  KBGM32.DLL 񂽂񃉃bp[NXYO
//=============================================================================

#include <windows.h>
#include "KBGMPlayer.h"

// ============================================================================
//  CKBGMPlayer : KBGM32.DLL yɎg!!
// ============================================================================

// ----------------------------------------------------------------------------
//	CKBGMPlayer NX̃RXgN^
// ----------------------------------------------------------------------------
CKBGMPlayer::CKBGMPlayer(bool initialize)
{
	if ( initialize )
		LibraryInitialize();
}

// ----------------------------------------------------------------------------
//	CKBGMPlayer NX̃fXgN^
// ----------------------------------------------------------------------------
CKBGMPlayer::~CKBGMPlayer()
{
	if ( loaded )
	{
		// ǂݍłnhꍇ͊J
		for ( int i = 0 ; i < KBGMPLAYER_HDATA_QTY ; i ++ )
		{
			if ( bgmloaded[i] ) Free(i);
		}

		(*funcs.lpStop)();
		(*funcs.lpClose)();
		FreeLibrary(funcs.hInst);
	}
}

// ----------------------------------------------------------------------------
//	KBGM32.DLL ̏
// ----------------------------------------------------------------------------
bool CKBGMPlayer::LibraryInitialize()
{
	if ( !loaded )
	{
		funcs.hInst = LoadLibrary("KBGM32.DLL");

		if ( funcs.hInst < (HINSTANCE)HINSTANCE_ERROR )
		{
			return false;
		}

		// ֐̃Gg|Cg擾
		funcs.lpOpen		= (KBGM_FUNC_KBGMOPEN)	GetProcAddress(funcs.hInst, "KBGMOpen");
		funcs.lpClose		= (KBGM_FUNC_CLOSE)		GetProcAddress(funcs.hInst, "KBGMClose");
		funcs.lpPlay		= (KBGM_FUNC_PLAY)		GetProcAddress(funcs.hInst, "KBGMPlay");
		funcs.lpResume		= (KBGM_FUNC_RESUME)	GetProcAddress(funcs.hInst, "KBGMResume");
		funcs.lpStop		= (KBGM_FUNC_STOP)		GetProcAddress(funcs.hInst, "KBGMStop");
		funcs.lpPause		= (KBGM_FUNC_PAUSE)		GetProcAddress(funcs.hInst, "KBGMPause");
		funcs.lpFree		= (KBGM_FUNC_FREE)		GetProcAddress(funcs.hInst, "KBGMFree");
		funcs.lpLoadRes		= (KBGM_FUNC_LOADRES)	GetProcAddress(funcs.hInst, "KBGMLoadRes");
		funcs.lpLoadFile	= (KBGM_FUNC_LOADFILE)	GetProcAddress(funcs.hInst, "KBGMLoadFile");
		funcs.lpInit		= (KBGM_FUNC_INIT)		GetProcAddress(funcs.hInst, "KBGMInit");
		funcs.lpGetInfo		= (KBGM_FUNC_GETINFO)	GetProcAddress(funcs.hInst, "KBGMGetInfo");
		funcs.lpSetVolume	= (KBGM_FUNC_SETVOLUME)	GetProcAddress(funcs.hInst, "KBGMSetVolume");
		funcs.lpSendSysx	= (KBGM_FUNC_SENDSYSX)	GetProcAddress(funcs.hInst, "KBGMSendSysx");
		funcs.lpFadeIn		= (KBGM_FUNC_FADEIN)	GetProcAddress(funcs.hInst, "KBGMFadeIn");
		funcs.lpFadeOut		= (KBGM_FUNC_FADEOUT)	GetProcAddress(funcs.hInst, "KBGMFadeOut");
		funcs.lpSetTempo	= (KBGM_FUNC_SETTEMPO)	GetProcAddress(funcs.hInst, "KBGMSetTempo");
		funcs.lpSeek		= (KBGM_FUNC_SEEK)		GetProcAddress(funcs.hInst, "KBGMSeek");
		funcs.lpSetRepeat	= (KBGM_FUNC_SETREPEAT)	GetProcAddress(funcs.hInst, "KBGMSetRepeat");
		funcs.lpNoteOn		= (KBGM_FUNC_NOTEON)	GetProcAddress(funcs.hInst, "KBGMNoteOn");
		funcs.lpSetCtrl		= (KBGM_FUNC_SETCTRL)	GetProcAddress(funcs.hInst, "KBGMSetCtrl");
		funcs.lpSetPrg		= (KBGM_FUNC_SETPRG)	GetProcAddress(funcs.hInst, "KBGMSetPrg");

		for ( int i = 0 ; i < KBGMPLAYER_HDATA_QTY ; i ++ )
		{
			bgmloaded[i] = false;
		}

		(*funcs.lpOpen)(10, MIDI_MAPPER);

		loaded = true;
	}

	return loaded;
}

// ----------------------------------------------------------------------------
//	SMF t@Cǂݍ
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::LoadFile(UINT num, LPSTR filename)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// hData Ƀt@Cǂݍ
	result = (*funcs.lpLoadFile)(&hData[num], filename);
	if ( result == KBGM_NOERROR ) bgmloaded[num] = true;

	return result;
}

// ----------------------------------------------------------------------------
//	\[X SMF ǂݍ
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::LoadRes(UINT num, HINSTANCE hInstApp, LPCSTR resname, LPCSTR restype)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// ɓǂݍݍς݂̂Ƃ͈UJ
	if ( bgmloaded[num] ) Free( num );

	// hData Ƀ\[Xǂݍ
	result = (*funcs.lpLoadRes)(&hData[num], hInstApp, resname, restype);
	if ( result == KBGM_NOERROR ) bgmloaded[num] = true;

	return result;
}

// ----------------------------------------------------------------------------
//	s
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::Init(UINT num)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;
	
	// 
	result = (*funcs.lpInit)(hData[num]);

	return result;
}

// ----------------------------------------------------------------------------
//	Đ
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::Play(UINT num, UINT type)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// BGM Đ
	result = (*funcs.lpPlay)(hData[num], type);

	return result;
}

// ----------------------------------------------------------------------------
//	~
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::Stop(void)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// BGM ~
	result = (*funcs.lpStop)();

	return result;
}

// ----------------------------------------------------------------------------
//	ꎞ~
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::Pause(void)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// BGM ꎞ~
	result = (*funcs.lpPause)();

	return result;
}

// ----------------------------------------------------------------------------
//	ǂݍ MIDI J
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::Free(UINT num)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// MIDI J
	result = (*funcs.lpFree)(hData[num]);
	if ( result == KBGM_NOERROR ) bgmloaded[num] = false;

	return result;
}

// ----------------------------------------------------------------------------
//	ꎞ~ĊJ
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::Resume(UINT num)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// ꎞ~ BGM ĊJ
	result = (*funcs.lpResume)(hData[num]);

	return result;
}

// ----------------------------------------------------------------------------
//	{[ύX
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::SetVolume(UINT num, UINT volume)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// {[ݒ
	result = (*funcs.lpSetVolume)(hData[num], volume);

	return result;
}

// ----------------------------------------------------------------------------
//	s[g̐ݒύX
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::SetRepeat(UINT num, DWORD times, DWORD seek)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// s[gݒ
	result = (*funcs.lpSetRepeat)(hData[num], times, seek);

	return result;
}

// ----------------------------------------------------------------------------
//	e|ݒ肷
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::SetTempo(UINT num, UINT beat)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// e|ݒ
	result = (*funcs.lpSetTempo)(hData[num], beat);

	return result;
}

// ----------------------------------------------------------------------------
//	SMF ̏擾
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::GetInfo(UINT num, LPSMFINFO lpSmfInfo)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// SMF擾
	result = (*funcs.lpGetInfo)(hData[num], lpSmfInfo);

	return result;
}

// ----------------------------------------------------------------------------
//	VXeGNXN[WubZ[W𑗐M
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::SendSysx(UINT type)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// VXeGNXN[WubZ[W𑗐M
	result = (*funcs.lpSendSysx)(type);

	return result;
}

// ----------------------------------------------------------------------------
//	tF[hC
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::FadeIn(UINT num, UINT Sec)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// tF[hC
	result = (*funcs.lpFadeIn)(hData[num], Sec);

	return result;
}

// ----------------------------------------------------------------------------
//	tF[hAEg
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::FadeOut(UINT num, UINT Sec)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// tF[hAEg
	result = (*funcs.lpFadeOut)(hData[num], Sec);

	return result;
}

// ----------------------------------------------------------------------------
//	V[N
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::Seek(UINT num, LONG Tick)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// V[N
	result = (*funcs.lpSeek)(hData[num], Tick);

	return result;
}

// ----------------------------------------------------------------------------
//	m[gI
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::NoteOn(BYTE ChNum, BYTE Note, BYTE Vel)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// 炷
	result = (*funcs.lpNoteOn)(ChNum, Note, Vel);

	return result;
}

// ----------------------------------------------------------------------------
//	Rg[bZ[W𑗂
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::SetCtrl(BYTE ChNum, BYTE Data1, BYTE Data2)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// Rg[bZ[W𑗂
	result = (*funcs.lpSetCtrl)(ChNum, Data1, Data2);

	return result;
}

// ----------------------------------------------------------------------------
//	Fw肷
// ----------------------------------------------------------------------------
UINT CKBGMPlayer::SetPrg(BYTE ChNum, BYTE Pnum)
{
	UINT	result;

	// łĂȂƂ͂߂
	if ( !loaded ) return KBGM_NOTLOADEDDLL;

	// Fw
	result = (*funcs.lpSetPrg)(ChNum, Pnum);

	return result;
}

//=============================================================================
//	end of file
//=============================================================================
